/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.strategy;

import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.action.AsyncEdgeAction;
import com.alibaba.cloud.ai.graph.action.AsyncNodeAction;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.FlowAgent;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.agent.flow.enums.FlowAgentEnum;
import com.alibaba.cloud.ai.graph.agent.flow.node.ConditionEvaluator;
import com.alibaba.cloud.ai.graph.agent.flow.node.ConditionEvaluatorAction;
import com.alibaba.cloud.ai.graph.agent.flow.node.TransparentNode;
import com.alibaba.cloud.ai.graph.agent.flow.strategy.FlowGraphBuildingStrategy;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import java.util.HashMap;
import java.util.Map;

public class ConditionalGraphBuildingStrategy
implements FlowGraphBuildingStrategy {
    @Override
    public StateGraph buildGraph(FlowGraphBuilder.FlowGraphConfig config) throws GraphStateException {
        this.validateConfig(config);
        this.validateConditionalConfig(config);
        StateGraph graph = config.getStateSerializer() != null ? new StateGraph(config.getName(), config.getKeyStrategyFactory(), config.getStateSerializer()) : new StateGraph(config.getName(), config.getKeyStrategyFactory());
        Agent rootAgent = config.getRootAgent();
        graph.addNode(rootAgent.name(), AsyncNodeAction.node_async((NodeAction)new TransparentNode()));
        graph.addEdge("__START__", rootAgent.name());
        String conditionNodeName = rootAgent.name() + "_condition";
        graph.addNode(conditionNodeName, AsyncNodeAction.node_async((NodeAction)new ConditionEvaluator()));
        graph.addEdge(rootAgent.name(), conditionNodeName);
        HashMap<String, String> conditionRoutingMap = new HashMap<String, String>();
        for (Map.Entry<String, Agent> entry : config.getConditionalAgents().entrySet()) {
            String condition = entry.getKey();
            Agent subAgent = entry.getValue();
            FlowGraphBuildingStrategy.addSubAgentNode(subAgent, graph);
            conditionRoutingMap.put(condition, subAgent.name());
            graph.addEdge(subAgent.name(), "__END__");
        }
        conditionRoutingMap.put("default", "__END__");
        graph.addConditionalEdges(conditionNodeName, (AsyncEdgeAction)new ConditionEvaluatorAction(), conditionRoutingMap);
        return graph;
    }

    @Override
    public String getStrategyType() {
        return FlowAgentEnum.CONDITIONAL.getType();
    }

    @Override
    public void validateConfig(FlowGraphBuilder.FlowGraphConfig config) {
        FlowGraphBuildingStrategy.super.validateConfig(config);
        this.validateConditionalConfig(config);
    }

    private void validateConditionalConfig(FlowGraphBuilder.FlowGraphConfig config) {
        if (config.getConditionalAgents() == null || config.getConditionalAgents().isEmpty()) {
            throw new IllegalArgumentException("Conditional flow requires at least one conditional agent mapping");
        }
        if (!(config.getRootAgent() instanceof FlowAgent)) {
            throw new IllegalArgumentException("Conditional flow requires root agent to be a FlowAgent");
        }
        for (String condition : config.getConditionalAgents().keySet()) {
            if (condition != null && !condition.trim().isEmpty()) continue;
            throw new IllegalArgumentException("Condition keys cannot be null or empty");
        }
    }
}

