/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.node;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.AsyncEdgeAction;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.flow.agent.SupervisorAgent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.converter.BeanOutputConverter;
import org.springframework.util.StringUtils;

public class SupervisorEdgeAction
implements AsyncEdgeAction {
    private static final Logger logger = LoggerFactory.getLogger(SupervisorEdgeAction.class);
    private static final int DEFAULT_MAX_RETRIES = 2;
    private final ChatClient chatClient;
    private final BeanOutputConverter<SupervisorDecision> outputConverter;
    private final Agent rootAgent;
    private final List<Agent> subAgents;

    public SupervisorEdgeAction(ChatModel chatModel, Agent rootAgent, List<Agent> subAgents) {
        SupervisorAgent supervisorAgent;
        this.rootAgent = rootAgent;
        this.subAgents = subAgents;
        StringBuilder sb = new StringBuilder();
        if (rootAgent instanceof SupervisorAgent && StringUtils.hasLength((String)(supervisorAgent = (SupervisorAgent)rootAgent).getSystemPrompt())) {
            sb.append("You are a supervisor agent responsible for task routing and completion decisions.\n Break down user requests into appropriate subtasks and delegate them to specialized agents when necessary.\n");
            sb.append("The instruction that you should follow to finish this task is:\n\n ");
            sb.append(supervisorAgent.getSystemPrompt());
        } else {
            sb.append("You are a supervisor agent responsible for task routing and completion decisions.\n Break down user requests into appropriate subtasks and delegate them to specialized agents when necessary.\n");
            sb.append("\n\n");
            sb.append("You have access to some specialized agents that can handle this task. You must decide:\n");
            sb.append("1. Delegate each subtask to ONE of the following agents, OR\n");
            sb.append("2. Mark the task as complete (FINISH) if no further action is needed.\n");
            sb.append("\n");
            sb.append("The available agents and their capabilities are listed below:\n");
            for (Agent agent : subAgents) {
                sb.append("- ").append(agent.name()).append(": ").append(agent.description()).append("\n");
            }
        }
        sb.append("\n");
        sb.append("You can also return \"FINISH\" to indicate that the task is complete and no further agent action is needed.\n");
        sb.append("\n");
        sb.append("Available options: ");
        sb.append(String.join((CharSequence)", ", subAgents.stream().map(Agent::name).toList()));
        sb.append(", FINISH");
        sb.append("\n\n");
        sb.append("Example: prose_writer_agent");
        sb.append("\n");
        sb.append("Example: FINISH");
        this.outputConverter = new BeanOutputConverter(SupervisorDecision.class);
        sb.append("\n\n");
        sb.append(this.outputConverter.getFormat());
        this.chatClient = ChatClient.builder((ChatModel)chatModel).defaultSystem(sb.toString()).build();
    }

    public CompletableFuture<String> apply(OverAllState state) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        try {
            List messages = (List)state.value("messages").orElseThrow();
            List<Message> messagesWithInstruction = this.prepareMessagesWithInstruction(messages);
            String decisionValue = this.getDecisionWithRetry(messagesWithInstruction, 2);
            if ("FINISH".equalsIgnoreCase(decisionValue)) {
                logger.info("Supervisor {} decided to finish the task.", (Object)this.rootAgent.name());
                result.complete("__END__");
            } else {
                boolean isValidAgent = this.subAgents.stream().anyMatch(agent -> agent.name().equals(decisionValue));
                if (isValidAgent) {
                    logger.info("Supervisor {} delegated to sub-agent {}.", (Object)this.rootAgent.name(), (Object)decisionValue);
                    result.complete(decisionValue);
                } else {
                    logger.error("Supervisor {} failed to get valid decision after {} retries. Last invalid decision: {}.", new Object[]{this.rootAgent.name(), 2, decisionValue});
                    result.completeExceptionally(new IllegalArgumentException("Invalid routing decision after retries: " + decisionValue + ". Must be one of the sub-agents or FINISH."));
                }
            }
        }
        catch (Exception e) {
            logger.error("Error during supervisor decision: ", (Throwable)e);
            result.completeExceptionally(e);
        }
        return result;
    }

    private List<Message> prepareMessagesWithInstruction(List<Message> messages) {
        ArrayList<Message> messagesWithInstruction = new ArrayList<Message>(messages);
        Agent agent = this.rootAgent;
        if (agent instanceof SupervisorAgent) {
            SupervisorAgent supervisorAgent = (SupervisorAgent)agent;
            String instruction = supervisorAgent.getInstruction();
            if (StringUtils.hasLength((String)instruction)) {
                messagesWithInstruction.add((Message)new UserMessage(instruction));
            } else {
                messagesWithInstruction.add((Message)new UserMessage("Based on the chat history and current task progress, please decide the next agent to delegate the task to, or return FINISH if you think the task is complete."));
            }
        } else {
            messagesWithInstruction.add((Message)new UserMessage("Based on the chat history and current task progress, please decide the next agent to delegate the task to, or return FINISH if you think the task is complete."));
        }
        return messagesWithInstruction;
    }

    private String getDecisionWithRetry(List<Message> messages, int maxRetries) throws Exception {
        String lastInvalidDecision = null;
        for (int attempt = 0; attempt <= maxRetries; ++attempt) {
            try {
                SupervisorDecision decision;
                if (attempt == 0) {
                    decision = (SupervisorDecision)this.chatClient.prompt().messages(messages).call().entity(this.outputConverter);
                } else {
                    String errorFeedback = String.format("Previous attempt returned an invalid agent name '%s'. Please choose from the available agents: %s, or return 'FINISH' if the task is complete.", lastInvalidDecision, String.join((CharSequence)", ", this.subAgents.stream().map(Agent::name).toList()));
                    logger.warn("Supervisor {} retry attempt {}/{}. Previous invalid decision: {}", new Object[]{this.rootAgent.name(), attempt, maxRetries, lastInvalidDecision});
                    ArrayList<Object> messagesWithFeedback = new ArrayList<Object>();
                    boolean systemMessageFound = false;
                    for (Message msg : messages) {
                        if (msg instanceof SystemMessage && !systemMessageFound) {
                            String enhancedContent = msg.getText() + "\n\n" + errorFeedback;
                            messagesWithFeedback.add(new SystemMessage(enhancedContent));
                            systemMessageFound = true;
                            continue;
                        }
                        messagesWithFeedback.add(msg);
                    }
                    if (!systemMessageFound) {
                        messagesWithFeedback.add(new UserMessage(errorFeedback));
                    }
                    decision = (SupervisorDecision)this.chatClient.prompt().messages(messagesWithFeedback).call().entity(this.outputConverter);
                }
                String decisionValue = decision.agent();
                if ("FINISH".equalsIgnoreCase(decisionValue)) {
                    if (attempt > 0) {
                        logger.info("Supervisor {} succeeded on retry attempt {}. Decision: FINISH", (Object)this.rootAgent.name(), (Object)attempt);
                    }
                    return decisionValue;
                }
                boolean isValidAgent = this.subAgents.stream().anyMatch(agent -> agent.name().equals(decisionValue));
                if (isValidAgent) {
                    if (attempt > 0) {
                        logger.info("Supervisor {} succeeded on retry attempt {}. Delegated to sub-agent: {}", new Object[]{this.rootAgent.name(), attempt, decisionValue});
                    }
                    return decisionValue;
                }
                lastInvalidDecision = decisionValue;
                logger.warn("Supervisor {} attempt {}/{} returned invalid agent name: {}", new Object[]{this.rootAgent.name(), attempt, maxRetries, decisionValue});
                continue;
            }
            catch (Exception e) {
                if (attempt == maxRetries) {
                    logger.error("Supervisor {} failed on final attempt {}/{}", new Object[]{this.rootAgent.name(), attempt, maxRetries, e});
                    throw e;
                }
                logger.warn("Supervisor {} attempt {}/{} encountered an error, will retry", new Object[]{this.rootAgent.name(), attempt, maxRetries, e});
            }
        }
        throw new IllegalStateException(String.format("Failed to get valid decision after %d retries. Last invalid decision: %s", maxRetries, lastInvalidDecision));
    }

    public record SupervisorDecision(String agent) {
    }
}

