/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.extension.tools.filesystem;

import java.io.File;
import java.util.ArrayList;
import java.util.function.BiFunction;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.ai.tool.function.FunctionToolCallback;

public class ListFilesTool
implements BiFunction<String, ToolContext, String> {
    public static final String DESCRIPTION = "Lists all files in the filesystem, filtering by directory.\n\nUsage:\n- The path parameter must be an absolute path, not a relative path\n- The list_files tool will return a list of all files in the specified directory.\n- This is very useful for exploring the file system and finding the right file to read or edit.\n- You should almost ALWAYS use this tool before using the Read or Edit tools.\n";

    @Override
    public String apply(@ToolParam(description="The directory path to list files from") String path, ToolContext toolContext) {
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            return "Error: Directory not found: " + path;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return "Error: Cannot read directory: " + path;
        }
        ArrayList<String> filePaths = new ArrayList<String>();
        for (File file : files) {
            filePaths.add(file.getAbsolutePath());
        }
        return String.join((CharSequence)"\n", filePaths);
    }

    public static ToolCallback createListFilesToolCallback(String description) {
        return FunctionToolCallback.builder((String)"ls", (BiFunction)new ListFilesTool()).description(description).inputType(String.class).build();
    }
}

