/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.extension.interceptor;

import com.alibaba.cloud.ai.graph.agent.extension.file.FilesystemBackend;
import com.alibaba.cloud.ai.graph.agent.extension.tools.filesystem.EditFileTool;
import com.alibaba.cloud.ai.graph.agent.extension.tools.filesystem.GlobTool;
import com.alibaba.cloud.ai.graph.agent.extension.tools.filesystem.GrepTool;
import com.alibaba.cloud.ai.graph.agent.extension.tools.filesystem.ListFilesTool;
import com.alibaba.cloud.ai.graph.agent.extension.tools.filesystem.ReadFileTool;
import com.alibaba.cloud.ai.graph.agent.extension.tools.filesystem.WriteFileTool;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelCallHandler;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelInterceptor;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelRequest;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelResponse;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.tool.ToolCallback;

public class FilesystemInterceptor
extends ModelInterceptor {
    private static final String EMPTY_CONTENT_WARNING = "System reminder: File exists but has empty contents";
    private static final int DEFAULT_READ_OFFSET = 0;
    private static final int DEFAULT_READ_LIMIT = 500;
    private static final String DEFAULT_SYSTEM_PROMPT = "## Filesystem Tools `ls`, `read_file`, `write_file`, `edit_file`, `glob`, `grep`\n\nYou have access to a filesystem which you can interact with using these tools.\nAll file paths must start with a /.\nAvoid using the root path because you might not have permission to read/write there.\n\n- ls: list files in a directory (requires absolute path)\n- read_file: read a file from the filesystem\n- write_file: write to a file in the filesystem\n- edit_file: edit a file in the filesystem\n- glob: find files matching a pattern (e.g., \"**/*.py\")\n- grep: search for text within files\n";
    private final List<ToolCallback> tools;
    private final String systemPrompt;
    private final boolean readOnly;
    private final Map<String, String> customToolDescriptions;
    private static final Pattern TRAVERSAL_PATTERN = Pattern.compile("\\.\\.|~");

    private FilesystemInterceptor(Builder builder) {
        this.readOnly = builder.readOnly;
        this.systemPrompt = builder.systemPrompt != null ? builder.systemPrompt : DEFAULT_SYSTEM_PROMPT;
        this.customToolDescriptions = builder.customToolDescriptions != null ? new HashMap<String, String>(builder.customToolDescriptions) : new HashMap();
        ArrayList<ToolCallback> toolList = new ArrayList<ToolCallback>();
        toolList.add(ListFilesTool.createListFilesToolCallback(this.customToolDescriptions.getOrDefault("ls", "Lists all files in the filesystem, filtering by directory.\n\nUsage:\n- The path parameter must be an absolute path, not a relative path\n- The list_files tool will return a list of all files in the specified directory.\n- This is very useful for exploring the file system and finding the right file to read or edit.\n- You should almost ALWAYS use this tool before using the Read or Edit tools.\n")));
        toolList.add(ReadFileTool.createReadFileToolCallback(this.customToolDescriptions.getOrDefault("read_file", "Reads a file from the filesystem. You can access any file directly by using this tool.\nAssume this tool is able to read all files on the machine. If the User provides a path to a file assume that path is valid. It is okay to read a file that does not exist; an error will be returned.\n\nUsage:\n- The file_path parameter must be an absolute path, not a relative path\n- By default, it reads up to 500 lines starting from the beginning of the file\n- **IMPORTANT for large files and codebase exploration**: Use pagination with offset and limit parameters to avoid context overflow\n  - First scan: read_file(path, limit=100) to see file structure\n  - Read more sections: read_file(path, offset=100, limit=200) for next 200 lines\n  - Only omit limit (read full file) when necessary for editing\n- Specify offset and limit: read_file(path, offset=0, limit=100) reads first 100 lines\n- Any lines longer than 2000 characters will be truncated\n- Results are returned using cat -n format, with line numbers starting at 1\n- You have the capability to call multiple tools in a single response. It is always better to speculatively read multiple files as a batch that are potentially useful.\n- If you read a file that exists but has empty contents you will receive a system reminder warning in place of file contents.\n\t\t\t- You should almost ALWAYS use the list_files tool before using this tool to verify the file path.\n")));
        if (!this.readOnly) {
            toolList.add(WriteFileTool.createWriteFileToolCallback(this.customToolDescriptions.getOrDefault("write_file", "Writes to a new file in the filesystem.\n\nUsage:\n- The file_path parameter must be an absolute path, not a relative path\n- The content parameter must be a string\n- The write_file tool will create a new file.\n- When writing to a file, the content will completely replace the existing content.\n")));
            toolList.add(EditFileTool.createEditFileToolCallback(this.customToolDescriptions.getOrDefault("edit_file", "Performs exact string replacements in files.\n\nUsage:\n- You must use your `read_file` tool at least once before editing.\n- When editing text from read_file output, preserve exact indentation\n- ALWAYS prefer editing existing files. NEVER write new files unless explicitly required.\n- The edit will FAIL if `old_string` is not unique in the file.\n- After editing, verify the changes by using the read_file tool.\n")));
        }
        toolList.add(GlobTool.createGlobToolCallback(this.customToolDescriptions.getOrDefault("glob", "Find files matching a glob pattern.\n\nUsage:\n- Supports standard glob patterns: `*` (any characters), `**` (any directories), `?` (single character)\n- Returns a list of absolute file paths that match the pattern\n\nExamples:\n- `**/*.java` - Find all Java files\n- `*.txt` - Find all text files in root\n- `/src/**/*.xml` - Find all XML files under /src\n")));
        toolList.add(GrepTool.createGrepToolCallback(this.customToolDescriptions.getOrDefault("grep", "Search for a pattern in files.\n\nUsage:\n- The pattern parameter is the text to search for (literal string, not regex)\n- The path parameter filters which directory to search in\n- The glob parameter accepts a glob pattern to filter which files to search\n\nExamples:\n- Search all files: `grep(pattern=\"TODO\")`\n- The search is case-sensitive by default.\n")));
        this.tools = Collections.unmodifiableList(toolList);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static String validatePath(String path, List<String> allowedPrefixes) {
        if (TRAVERSAL_PATTERN.matcher(path).find()) {
            throw new IllegalArgumentException("Path traversal not allowed: " + path);
        }
        Object normalized = path.replace("\\", "/");
        if (!((String)(normalized = Paths.get((String)normalized, new String[0]).normalize().toString().replace("\\", "/"))).startsWith("/")) {
            normalized = "/" + (String)normalized;
        }
        if (allowedPrefixes != null && !allowedPrefixes.isEmpty()) {
            boolean hasValidPrefix = false;
            for (String prefix : allowedPrefixes) {
                if (!((String)normalized).startsWith(prefix)) continue;
                hasValidPrefix = true;
                break;
            }
            if (!hasValidPrefix) {
                throw new IllegalArgumentException("Path must start with one of " + allowedPrefixes + ": " + path);
            }
        }
        return normalized;
    }

    @Override
    public List<ToolCallback> getTools() {
        return this.tools;
    }

    @Override
    public String getName() {
        return "Filesystem";
    }

    @Override
    public ModelResponse interceptModel(ModelRequest request, ModelCallHandler handler) {
        SystemMessage enhancedSystemMessage = request.getSystemMessage() == null ? new SystemMessage(this.systemPrompt) : new SystemMessage(request.getSystemMessage().getText() + "\n\n" + this.systemPrompt);
        ModelRequest enhancedRequest = ModelRequest.builder(request).systemMessage(enhancedSystemMessage).build();
        return handler.call(enhancedRequest);
    }

    public static class Builder {
        private String systemPrompt;
        private boolean readOnly = false;
        private Map<String, String> customToolDescriptions;
        private FilesystemBackend backend;

        public Builder systemPrompt(String systemPrompt) {
            this.systemPrompt = systemPrompt;
            return this;
        }

        public Builder readOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public Builder customToolDescriptions(Map<String, String> customToolDescriptions) {
            this.customToolDescriptions = customToolDescriptions;
            return this;
        }

        public Builder addCustomToolDescription(String toolName, String description) {
            if (this.customToolDescriptions == null) {
                this.customToolDescriptions = new HashMap<String, String>();
            }
            this.customToolDescriptions.put(toolName, description);
            return this;
        }

        public FilesystemInterceptor build() {
            return new FilesystemInterceptor(this);
        }
    }
}

