/*
 * Decompiled with CFR 0.152.
 */
package chrome.tabs;

import chrome.ChromeAPI;
import chrome.events.EventSource;
import chrome.events.EventSourceImplicits$;
import chrome.permissions.Permission;
import chrome.permissions.Permission$API$;
import chrome.runtime.bindings.Port;
import chrome.tabs.bindings.ActiveInfo;
import chrome.tabs.bindings.AttachInfo;
import chrome.tabs.bindings.ChangeInfo;
import chrome.tabs.bindings.CodeInjectionOptions;
import chrome.tabs.bindings.DetachInfo;
import chrome.tabs.bindings.HighlightInfo;
import chrome.tabs.bindings.MoveInfo;
import chrome.tabs.bindings.MoveProperties;
import chrome.tabs.bindings.ReloadProperties;
import chrome.tabs.bindings.RemoveInfo;
import chrome.tabs.bindings.Tab;
import chrome.tabs.bindings.TabCreateProperties;
import chrome.tabs.bindings.TabQuery;
import chrome.tabs.bindings.UpdateProperties;
import chrome.tabs.bindings.ZoomChangeInfo;
import chrome.tabs.bindings.ZoomSettings;
import chrome.utils.ErrorHandling$;
import chrome.windows.bindings.Window;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Any;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Array;
import scala.scalajs.js.Array$;
import scala.scalajs.js.Object;
import scala.scalajs.js.package$;

public final class Tabs$
implements ChromeAPI,
Serializable {
    private static final Set requiredPermissions;
    private static final EventSource onCreated;
    private static final EventSource onUpdated;
    private static final EventSource onMoved;
    private static final EventSource onActivated;
    private static final EventSource onHighlighted;
    private static final EventSource onDetached;
    private static final EventSource onAttached;
    private static final EventSource onRemoved;
    private static final EventSource onReplaced;
    private static final EventSource onZoomChange;
    public static final Tabs$ MODULE$;

    private Tabs$() {
    }

    static {
        MODULE$ = new Tabs$();
        requiredPermissions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((java.lang.Object[])new Permission.API[]{Permission$API$.MODULE$.Tabs()}));
        onCreated = EventSourceImplicits$.MODULE$.eventAsEventSource1(chrome.tabs.bindings.Tabs$.MODULE$.onCreated());
        onUpdated = EventSourceImplicits$.MODULE$.eventAsEventSource3(chrome.tabs.bindings.Tabs$.MODULE$.onUpdated());
        onMoved = EventSourceImplicits$.MODULE$.eventAsEventSource2(chrome.tabs.bindings.Tabs$.MODULE$.onMoved());
        onActivated = EventSourceImplicits$.MODULE$.eventAsEventSource1(chrome.tabs.bindings.Tabs$.MODULE$.onActivated());
        onHighlighted = EventSourceImplicits$.MODULE$.eventAsEventSource1(chrome.tabs.bindings.Tabs$.MODULE$.onHighlighted());
        onDetached = EventSourceImplicits$.MODULE$.eventAsEventSource2(chrome.tabs.bindings.Tabs$.MODULE$.onDetached());
        onAttached = EventSourceImplicits$.MODULE$.eventAsEventSource2(chrome.tabs.bindings.Tabs$.MODULE$.onAttached());
        onRemoved = EventSourceImplicits$.MODULE$.eventAsEventSource2(chrome.tabs.bindings.Tabs$.MODULE$.onRemoved());
        onReplaced = EventSourceImplicits$.MODULE$.eventAsEventSource2(chrome.tabs.bindings.Tabs$.MODULE$.onReplaced());
        onZoomChange = EventSourceImplicits$.MODULE$.eventAsEventSource1(chrome.tabs.bindings.Tabs$.MODULE$.onZoomChange());
    }

    private java.lang.Object writeReplace() {
        return new ModuleSerializationProxy(Tabs$.class);
    }

    @Override
    public Set<Permission.API> requiredPermissions() {
        return requiredPermissions;
    }

    public EventSource<Tab> onCreated() {
        return onCreated;
    }

    public EventSource<Tuple3<java.lang.Object, ChangeInfo, Tab>> onUpdated() {
        return onUpdated;
    }

    public EventSource<Tuple2<java.lang.Object, MoveInfo>> onMoved() {
        return onMoved;
    }

    public EventSource<ActiveInfo> onActivated() {
        return onActivated;
    }

    public EventSource<HighlightInfo> onHighlighted() {
        return onHighlighted;
    }

    public EventSource<Tuple2<java.lang.Object, DetachInfo>> onDetached() {
        return onDetached;
    }

    public EventSource<Tuple2<java.lang.Object, AttachInfo>> onAttached() {
        return onAttached;
    }

    public EventSource<Tuple2<java.lang.Object, RemoveInfo>> onRemoved() {
        return onRemoved;
    }

    public EventSource<Tuple2<java.lang.Object, java.lang.Object>> onReplaced() {
        return onReplaced;
    }

    public EventSource<ZoomChangeInfo> onZoomChange() {
        return onZoomChange;
    }

    public Future<Tab> get(int tabId) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.get(tabId, tab -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.get$$anonfun$2$$anonfun$1(tab))));
        return promise.future();
    }

    public Future<Tab> getCurrent() {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.getCurrent(tab -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.getCurrent$$anonfun$2$$anonfun$1(tab))));
        return promise.future();
    }

    public Port connect(int tabId, java.lang.Object connectInfo) {
        return chrome.tabs.bindings.Tabs$.MODULE$.connect(tabId, connectInfo);
    }

    public java.lang.Object connect$default$2() {
        return package$.MODULE$.undefined();
    }

    public Future<Any> sendRequest(int tabId, Any request) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.sendRequest(tabId, request, Any$.MODULE$.fromFunction1((Function1 & Serializable)response -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.sendRequest$$anonfun$2$$anonfun$1(response)))));
        return promise.future();
    }

    public Future<Any> sendMessage(int tabId, Any message, java.lang.Object options) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.sendMessage(tabId, message, options, Any$.MODULE$.fromFunction1((Function1 & Serializable)response -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.sendMessage$$anonfun$2$$anonfun$1(response)))));
        return promise.future();
    }

    public java.lang.Object sendMessage$default$3() {
        return package$.MODULE$.undefined();
    }

    public Future<Tab> create(TabCreateProperties createProperties) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.create(createProperties, Any$.MODULE$.fromFunction1((Function1 & Serializable)tab -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.create$$anonfun$2$$anonfun$1(tab)))));
        return promise.future();
    }

    public Future<java.lang.Object> duplicate(int tabId) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.duplicate(tabId, Any$.MODULE$.fromFunction1((Function1 & Serializable)tab -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.duplicate$$anonfun$2$$anonfun$1(tab)))));
        return promise.future();
    }

    public Future<Array<Tab>> query(TabQuery queryInfo) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.query(queryInfo, Any$.MODULE$.fromFunction1((Function1 & Serializable)tabs -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.query$$anonfun$2$$anonfun$1(tabs)))));
        return promise.future();
    }

    public Future<Window> highlight(HighlightInfo highlightInfo) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.highlight(highlightInfo, Any$.MODULE$.fromFunction1((Function1 & Serializable)window -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.highlight$$anonfun$2$$anonfun$1(window)))));
        return promise.future();
    }

    public Future<java.lang.Object> update(java.lang.Object tabId, UpdateProperties updateProperties) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.update(tabId, updateProperties, Any$.MODULE$.fromFunction1((Function1 & Serializable)tabs -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.update$$anonfun$2$$anonfun$1(tabs)))));
        return promise.future();
    }

    public java.lang.Object update$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<Array<Tab>> move(Array<java.lang.Object> tabIds, MoveProperties moveProperties) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.move((Any)tabIds, moveProperties, Any$.MODULE$.fromFunction1((Function1 & Serializable)tabs -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.move$$anonfun$2$$anonfun$1(tabs)))));
        return promise.future();
    }

    public Future<BoxedUnit> reload(java.lang.Object tabId, ReloadProperties reloadProperties) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.reload(tabId, reloadProperties, Any$.MODULE$.fromFunction0((Function0 & Serializable)() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            this.reload$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        }))));
        return promise.future();
    }

    public java.lang.Object reload$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<BoxedUnit> remove(Array<java.lang.Object> tabIds) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.remove((Any)tabIds, Any$.MODULE$.fromFunction0((Function0 & Serializable)() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            this.remove$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        }))));
        return promise.future();
    }

    public Future<String> detectLanguage(java.lang.Object tabId) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.detectLanguage(tabId, Any$.MODULE$.fromFunction1((Function1 & Serializable)language -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.detectLanguage$$anonfun$2$$anonfun$1(language)))));
        return promise.future();
    }

    public java.lang.Object detectLanguage$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<String> captureVisibleTab(java.lang.Object windowId, java.lang.Object options) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.captureVisibleTab(windowId, options, Any$.MODULE$.fromFunction1((Function1 & Serializable)dataUrl -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.captureVisibleTab$$anonfun$2$$anonfun$1(dataUrl)))));
        return promise.future();
    }

    public java.lang.Object captureVisibleTab$default$1() {
        return package$.MODULE$.undefined();
    }

    public java.lang.Object captureVisibleTab$default$2() {
        return package$.MODULE$.undefined();
    }

    public Future<java.lang.Object> executeScript(java.lang.Object tabId, CodeInjectionOptions details) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.executeScript(tabId, details, Any$.MODULE$.fromFunction1((Function1 & Serializable)result -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.executeScript$$anonfun$2$$anonfun$1(result)))));
        return promise.future();
    }

    public java.lang.Object executeScript$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<BoxedUnit> insertCSS(java.lang.Object tabId, CodeInjectionOptions details) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.insertCSS(tabId, details, Any$.MODULE$.fromFunction0((Function0 & Serializable)() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            this.insertCSS$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        }))));
        return promise.future();
    }

    public java.lang.Object insertCSS$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<BoxedUnit> setZoom(java.lang.Object tabId, double zoomFactor) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.setZoom(tabId, zoomFactor, Any$.MODULE$.fromFunction0((Function0 & Serializable)() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            this.setZoom$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        }))));
        return promise.future();
    }

    public java.lang.Object setZoom$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<java.lang.Object> getZoom(java.lang.Object tabId) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.getZoom(tabId, Any$.MODULE$.fromFunction1((Function1 & Serializable)zoomFactor -> this.getZoom$$anonfun$2(promise, BoxesRunTime.unboxToDouble((java.lang.Object)zoomFactor))));
        return promise.future();
    }

    public java.lang.Object getZoom$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<BoxedUnit> setZoomSettings(java.lang.Object tabId, ZoomSettings zoomSettings) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.setZoomSettings(tabId, zoomSettings, Any$.MODULE$.fromFunction0((Function0 & Serializable)() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            this.setZoomSettings$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        }))));
        return promise.future();
    }

    public java.lang.Object setZoomSettings$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<ZoomSettings> getZoomSettings(java.lang.Object tabId) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.getZoomSettings(tabId, Any$.MODULE$.fromFunction1((Function1 & Serializable)zoomSettings -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.getZoomSettings$$anonfun$2$$anonfun$1(zoomSettings)))));
        return promise.future();
    }

    public java.lang.Object getZoomSettings$default$1() {
        return package$.MODULE$.undefined();
    }

    private final Tab get$$anonfun$2$$anonfun$1(Tab tab$1) {
        return tab$1;
    }

    private final Tab getCurrent$$anonfun$2$$anonfun$1(Tab tab$2) {
        return tab$2;
    }

    private final Any sendRequest$$anonfun$2$$anonfun$1(Any response$1) {
        return response$1;
    }

    private final Any sendMessage$$anonfun$2$$anonfun$1(Any response$2) {
        return response$2;
    }

    private final Tab create$$anonfun$2$$anonfun$1(Tab tab$3) {
        return tab$3;
    }

    private final java.lang.Object duplicate$$anonfun$2$$anonfun$1(java.lang.Object tab$4) {
        return tab$4;
    }

    private final Array query$$anonfun$2$$anonfun$1(Array tabs$1) {
        return tabs$1;
    }

    private final Window highlight$$anonfun$2$$anonfun$1(Window window$1) {
        return window$1;
    }

    private final java.lang.Object update$$anonfun$2$$anonfun$1(java.lang.Object tabs$2) {
        return tabs$2;
    }

    private final Array move$$anonfun$2$$anonfun$1(Object tabs$3) {
        return tabs$3 instanceof Array ? (Array)tabs$3 : Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((java.lang.Object[])new Tab[]{(Tab)tabs$3}));
    }

    private final void reload$$anonfun$2$$anonfun$1() {
    }

    private final void remove$$anonfun$2$$anonfun$1() {
    }

    private final String detectLanguage$$anonfun$2$$anonfun$1(String language$1) {
        return language$1;
    }

    private final String captureVisibleTab$$anonfun$2$$anonfun$1(String dataUrl$1) {
        return dataUrl$1;
    }

    private final java.lang.Object executeScript$$anonfun$2$$anonfun$1(java.lang.Object result$1) {
        return result$1;
    }

    private final void insertCSS$$anonfun$2$$anonfun$1() {
    }

    private final void setZoom$$anonfun$2$$anonfun$1() {
    }

    private final double getZoom$$anonfun$1$$anonfun$1(double zoomFactor$1) {
        return zoomFactor$1;
    }

    private final /* synthetic */ Promise getZoom$$anonfun$2(Promise promise$18, double zoomFactor) {
        return promise$18.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.getZoom$$anonfun$1$$anonfun$1(zoomFactor)));
    }

    private final void setZoomSettings$$anonfun$2$$anonfun$1() {
    }

    private final ZoomSettings getZoomSettings$$anonfun$2$$anonfun$1(ZoomSettings zoomSettings$1) {
        return zoomSettings$1;
    }
}

