/*
 * Decompiled with CFR 0.152.
 */
package chrome.sockets.tcpServer;

import chrome.events.EventSource;
import chrome.sockets.tcp.Socket$;
import chrome.sockets.tcpServer.Socket$Accepted$;
import chrome.sockets.tcpServer.Socket$Error$;
import chrome.sockets.tcpServer.TCPServer$;
import chrome.sockets.tcpServer.bindings.AcceptErrorEvent;
import chrome.sockets.tcpServer.bindings.SocketInfo;
import chrome.sockets.tcpServer.bindings.SocketProperties;
import chrome.utils.ErrorHandling$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.scalajs.js.JSConverters;
import scala.scalajs.js.JSConverters$;
import scala.scalajs.js.package$;

public class Socket {
    private final int socketId;
    private final EventSource onAccept;
    private final EventSource onAcceptError;
    private final EventSource all;

    public static Socket apply(int n) {
        return chrome.sockets.tcpServer.Socket$.MODULE$.apply(n);
    }

    public static Future<Socket> apply(String string, boolean bl) {
        return chrome.sockets.tcpServer.Socket$.MODULE$.apply(string, bl);
    }

    public static String apply$default$1() {
        return chrome.sockets.tcpServer.Socket$.MODULE$.apply$default$1();
    }

    public Socket(int socketId) {
        this.socketId = socketId;
        this.onAccept = TCPServer$.MODULE$.onAccept().filter((Function1<chrome.sockets.tcpServer.bindings.AcceptEvent, Object>)(Function1 & Serializable)_$1 -> _$1.socketId() == socketId).map((Function1 & Serializable)event -> Socket$Accepted$.MODULE$.apply(Socket$.MODULE$.apply(event.clientSocketId())));
        this.onAcceptError = TCPServer$.MODULE$.onAcceptError().filter((Function1<AcceptErrorEvent, Object>)(Function1 & Serializable)_$2 -> _$2.socketId() == socketId).map((Function1 & Serializable)event -> Socket$Error$.MODULE$.apply(event.resultCode()));
        this.all = this.onAccept().merge(this.onAcceptError());
    }

    public int socketId() {
        return this.socketId;
    }

    public EventSource<Accepted> onAccept() {
        return this.onAccept;
    }

    public EventSource<Error> onAcceptError() {
        return this.onAcceptError;
    }

    public EventSource<AcceptEvent> all() {
        return this.all;
    }

    public Future<BoxedUnit> update(SocketProperties properties) {
        Promise promise = Promise$.MODULE$.apply();
        Option option = JSConverters$.MODULE$.JSRichOption(Option$.MODULE$.apply(() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            Socket.update$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        }))));
        chrome.sockets.tcpServer.bindings.TCPServer$.MODULE$.update(this.socketId(), properties, JSConverters.JSRichOption$.MODULE$.orUndefined$extension(option));
        return promise.future();
    }

    public Future<BoxedUnit> setPaused(boolean paused) {
        Promise promise = Promise$.MODULE$.apply();
        Option option = JSConverters$.MODULE$.JSRichOption(Option$.MODULE$.apply(() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            Socket.setPaused$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        }))));
        chrome.sockets.tcpServer.bindings.TCPServer$.MODULE$.setPaused(this.socketId(), paused, JSConverters.JSRichOption$.MODULE$.orUndefined$extension(option));
        return promise.future();
    }

    public Future<Object> listen(String address, int port, Object backlog) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.sockets.tcpServer.bindings.TCPServer$.MODULE$.listen(this.socketId(), address, port, backlog, result -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> Socket.listen$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToInt((Object)result)))));
        return promise.future();
    }

    public Object listen$default$3() {
        return package$.MODULE$.undefined();
    }

    public Future<BoxedUnit> disconnect() {
        Promise promise = Promise$.MODULE$.apply();
        Option option = JSConverters$.MODULE$.JSRichOption(Option$.MODULE$.apply(() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            Socket.disconnect$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        }))));
        chrome.sockets.tcpServer.bindings.TCPServer$.MODULE$.disconnect(this.socketId(), JSConverters.JSRichOption$.MODULE$.orUndefined$extension(option));
        return promise.future();
    }

    public Future<BoxedUnit> close() {
        Promise promise = Promise$.MODULE$.apply();
        Option option = JSConverters$.MODULE$.JSRichOption(Option$.MODULE$.apply(() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            Socket.close$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        }))));
        chrome.sockets.tcpServer.bindings.TCPServer$.MODULE$.close(this.socketId(), JSConverters.JSRichOption$.MODULE$.orUndefined$extension(option));
        return promise.future();
    }

    public Future<SocketInfo> getInfo() {
        Promise promise = Promise$.MODULE$.apply();
        chrome.sockets.tcpServer.bindings.TCPServer$.MODULE$.getInfo(this.socketId(), info -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> Socket.getInfo$$anonfun$2$$anonfun$1(info))));
        return promise.future();
    }

    private static final void update$$anonfun$2$$anonfun$1() {
    }

    private static final void setPaused$$anonfun$2$$anonfun$1() {
    }

    private static final int listen$$anonfun$1$$anonfun$1(int result$1) {
        return result$1;
    }

    private static final void disconnect$$anonfun$2$$anonfun$1() {
    }

    private static final void close$$anonfun$2$$anonfun$1() {
    }

    private static final SocketInfo getInfo$$anonfun$2$$anonfun$1(SocketInfo info$1) {
        return info$1;
    }

    public static interface AcceptEvent {
    }

    public static class Accepted
    implements AcceptEvent,
    Product,
    Serializable {
        private final chrome.sockets.tcp.Socket client;

        public static Accepted apply(chrome.sockets.tcp.Socket socket) {
            return Socket$Accepted$.MODULE$.apply(socket);
        }

        public static Accepted fromProduct(Product product) {
            return Socket$Accepted$.MODULE$.fromProduct(product);
        }

        public static Accepted unapply(Accepted accepted) {
            return Socket$Accepted$.MODULE$.unapply(accepted);
        }

        public Accepted(chrome.sockets.tcp.Socket client) {
            this.client = client;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Accepted)) return false;
            Accepted accepted = (Accepted)object;
            chrome.sockets.tcp.Socket socket = this.client();
            chrome.sockets.tcp.Socket socket2 = accepted.client();
            if (socket == null) {
                if (socket2 != null) {
                    return false;
                }
            } else if (!socket.equals(socket2)) return false;
            if (!accepted.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Accepted;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Accepted";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "client";
        }

        public chrome.sockets.tcp.Socket client() {
            return this.client;
        }

        public Accepted copy(chrome.sockets.tcp.Socket client) {
            return new Accepted(client);
        }

        public chrome.sockets.tcp.Socket copy$default$1() {
            return this.client();
        }

        public chrome.sockets.tcp.Socket _1() {
            return this.client();
        }
    }

    public static class Error
    implements AcceptEvent,
    Product,
    Serializable {
        private final int code;

        public static Error apply(int n) {
            return Socket$Error$.MODULE$.apply(n);
        }

        public static Error fromProduct(Product product) {
            return Socket$Error$.MODULE$.fromProduct(product);
        }

        public static Error unapply(Error error) {
            return Socket$Error$.MODULE$.unapply(error);
        }

        public Error(int code) {
            this.code = code;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.code());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Error)) return false;
            Error error = (Error)object;
            if (this.code() != error.code()) return false;
            if (!error.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Error;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Error";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "code";
        }

        public int code() {
            return this.code;
        }

        public Error copy(int code) {
            return new Error(code);
        }

        public int copy$default$1() {
            return this.code();
        }

        public int _1() {
            return this.code();
        }
    }
}

