/*
 * Decompiled with CFR 0.152.
 */
package chrome.sockets.tcp;

import chrome.events.EventSource;
import chrome.sockets.tcp.Socket$;
import chrome.sockets.tcp.Socket$Error$;
import chrome.sockets.tcp.Socket$Received$;
import chrome.sockets.tcp.TCP$;
import chrome.sockets.tcp.bindings.ReceiveErrorEvent;
import chrome.sockets.tcp.bindings.SendInfo;
import chrome.sockets.tcp.bindings.SocketInfo;
import chrome.sockets.tcp.bindings.SocketProperties;
import chrome.utils.ErrorHandling$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.scalajs.js.JSConverters;
import scala.scalajs.js.JSConverters$;
import scala.scalajs.js.package$;
import scala.scalajs.js.typedarray.ArrayBuffer;

public class Socket {
    private final int socketId;
    private final EventSource onReceive;
    private final EventSource onReceiveError;
    private final EventSource all;

    public static Socket apply(int n) {
        return Socket$.MODULE$.apply(n);
    }

    public static Future<Socket> apply(String string, boolean bl, int n) {
        return Socket$.MODULE$.apply(string, bl, n);
    }

    public static String apply$default$1() {
        return Socket$.MODULE$.apply$default$1();
    }

    public Socket(int socketId) {
        this.socketId = socketId;
        this.onReceive = TCP$.MODULE$.onReceive().filter((Function1<chrome.sockets.tcp.bindings.ReceiveEvent, Object>)(Function1 & Serializable)_$1 -> _$1.socketId() == socketId).map((Function1 & Serializable)event -> Socket$Received$.MODULE$.apply(event.data()));
        this.onReceiveError = TCP$.MODULE$.onReceiveError().filter((Function1<ReceiveErrorEvent, Object>)(Function1 & Serializable)_$2 -> _$2.socketId() == socketId).map((Function1 & Serializable)event -> Socket$Error$.MODULE$.apply(event.resultCode()));
        this.all = this.onReceive().merge(this.onReceiveError());
    }

    public int socketId() {
        return this.socketId;
    }

    public EventSource<Received> onReceive() {
        return this.onReceive;
    }

    public EventSource<Error> onReceiveError() {
        return this.onReceiveError;
    }

    public EventSource<ReceiveEvent> all() {
        return this.all;
    }

    public Future<BoxedUnit> update(SocketProperties properties) {
        Promise promise = Promise$.MODULE$.apply();
        Option option = JSConverters$.MODULE$.JSRichOption(Option$.MODULE$.apply(() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            Socket.update$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        }))));
        chrome.sockets.tcp.bindings.TCP$.MODULE$.update(this.socketId(), properties, JSConverters.JSRichOption$.MODULE$.orUndefined$extension(option));
        return promise.future();
    }

    public Future<BoxedUnit> setPaused(boolean paused) {
        Promise promise = Promise$.MODULE$.apply();
        Option option = JSConverters$.MODULE$.JSRichOption(Option$.MODULE$.apply(() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            Socket.setPaused$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        }))));
        chrome.sockets.tcp.bindings.TCP$.MODULE$.setPaused(this.socketId(), paused, JSConverters.JSRichOption$.MODULE$.orUndefined$extension(option));
        return promise.future();
    }

    public Future<Object> setKeepAlive(boolean enable, Object delay) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.sockets.tcp.bindings.TCP$.MODULE$.setKeepAlive(this.socketId(), enable, delay, i -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> Socket.setKeepAlive$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToInt((Object)i)))));
        return promise.future();
    }

    public Object setKeepAlive$default$2() {
        return package$.MODULE$.undefined();
    }

    public Future<Object> setNoDelay(boolean noDelay) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.sockets.tcp.bindings.TCP$.MODULE$.setNoDelay(this.socketId(), noDelay, i -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> Socket.setNoDelay$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToInt((Object)i)))));
        return promise.future();
    }

    public Future<Object> connect(String peerAddress, int peerPort) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.sockets.tcp.bindings.TCP$.MODULE$.connect(this.socketId(), peerAddress, peerPort, i -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> Socket.connect$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToInt((Object)i)))));
        return promise.future();
    }

    public Future<BoxedUnit> disconnect() {
        Promise promise = Promise$.MODULE$.apply();
        Option option = JSConverters$.MODULE$.JSRichOption(Option$.MODULE$.apply(() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            Socket.disconnect$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        }))));
        chrome.sockets.tcp.bindings.TCP$.MODULE$.disconnect(this.socketId(), JSConverters.JSRichOption$.MODULE$.orUndefined$extension(option));
        return promise.future();
    }

    public Future<BoxedUnit> secure(Object options) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.sockets.tcp.bindings.TCP$.MODULE$.secure(this.socketId(), options, () -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            Socket.secure$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        })));
        return promise.future();
    }

    public Future<SendInfo> send(ArrayBuffer data) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.sockets.tcp.bindings.TCP$.MODULE$.send(this.socketId(), data, info -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> Socket.send$$anonfun$2$$anonfun$1(info))));
        return promise.future();
    }

    public Future<BoxedUnit> close() {
        Promise promise = Promise$.MODULE$.apply();
        chrome.sockets.tcp.bindings.TCP$.MODULE$.close(this.socketId(), () -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            Socket.close$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        })));
        return promise.future();
    }

    public Future<SocketInfo> getInfo() {
        Promise promise = Promise$.MODULE$.apply();
        chrome.sockets.tcp.bindings.TCP$.MODULE$.getInfo(this.socketId(), info -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> Socket.getInfo$$anonfun$2$$anonfun$1(info))));
        return promise.future();
    }

    private static final void update$$anonfun$2$$anonfun$1() {
    }

    private static final void setPaused$$anonfun$2$$anonfun$1() {
    }

    private static final int setKeepAlive$$anonfun$1$$anonfun$1(int i$1) {
        return i$1;
    }

    private static final int setNoDelay$$anonfun$1$$anonfun$1(int i$2) {
        return i$2;
    }

    private static final int connect$$anonfun$1$$anonfun$1(int i$3) {
        return i$3;
    }

    private static final void disconnect$$anonfun$2$$anonfun$1() {
    }

    private static final void secure$$anonfun$2$$anonfun$1() {
    }

    private static final SendInfo send$$anonfun$2$$anonfun$1(SendInfo info$1) {
        return info$1;
    }

    private static final void close$$anonfun$2$$anonfun$1() {
    }

    private static final SocketInfo getInfo$$anonfun$2$$anonfun$1(SocketInfo info$2) {
        return info$2;
    }

    public static class Error
    implements ReceiveEvent,
    Product,
    Serializable {
        private final int code;

        public static Error apply(int n) {
            return Socket$Error$.MODULE$.apply(n);
        }

        public static Error fromProduct(Product product) {
            return Socket$Error$.MODULE$.fromProduct(product);
        }

        public static Error unapply(Error error) {
            return Socket$Error$.MODULE$.unapply(error);
        }

        public Error(int code) {
            this.code = code;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.code());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Error)) return false;
            Error error = (Error)object;
            if (this.code() != error.code()) return false;
            if (!error.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Error;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Error";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "code";
        }

        public int code() {
            return this.code;
        }

        public Error copy(int code) {
            return new Error(code);
        }

        public int copy$default$1() {
            return this.code();
        }

        public int _1() {
            return this.code();
        }
    }

    public static interface ReceiveEvent {
    }

    public static class Received
    implements ReceiveEvent,
    Product,
    Serializable {
        private final ArrayBuffer data;

        public static Received apply(ArrayBuffer arrayBuffer) {
            return Socket$Received$.MODULE$.apply(arrayBuffer);
        }

        public static Received fromProduct(Product product) {
            return Socket$Received$.MODULE$.fromProduct(product);
        }

        public static Received unapply(Received received) {
            return Socket$Received$.MODULE$.unapply(received);
        }

        public Received(ArrayBuffer data) {
            this.data = data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Received)) return false;
            Received received = (Received)object;
            ArrayBuffer arrayBuffer = this.data();
            ArrayBuffer arrayBuffer2 = received.data();
            if (arrayBuffer == null) {
                if (arrayBuffer2 != null) {
                    return false;
                }
            } else if (!arrayBuffer.equals(arrayBuffer2)) return false;
            if (!received.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Received;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Received";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "data";
        }

        public ArrayBuffer data() {
            return this.data;
        }

        public Received copy(ArrayBuffer data) {
            return new Received(data);
        }

        public ArrayBuffer copy$default$1() {
            return this.data();
        }

        public ArrayBuffer _1() {
            return this.data();
        }
    }
}

