/*
 * Decompiled with CFR 0.152.
 */
package chrome.management;

import chrome.ChromeAPI;
import chrome.events.EventSource;
import chrome.events.EventSourceImplicits$;
import chrome.management.bindings.ExtensionInfo;
import chrome.permissions.Permission;
import chrome.permissions.Permission$API$;
import chrome.utils.ErrorHandling$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Array;
import scala.scalajs.js.package$;

public final class Management$
implements ChromeAPI,
Serializable {
    private static final Set requiredPermissions;
    private static final EventSource onInstalled;
    private static final EventSource onUninstalled;
    private static final EventSource onEnabled;
    private static final EventSource onDisabled;
    public static final Management$ MODULE$;

    private Management$() {
    }

    static {
        MODULE$ = new Management$();
        requiredPermissions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission.API[]{Permission$API$.MODULE$.Management()}));
        onInstalled = EventSourceImplicits$.MODULE$.eventAsEventSource1(chrome.management.bindings.Management$.MODULE$.onInstalled());
        onUninstalled = EventSourceImplicits$.MODULE$.eventAsEventSource1(chrome.management.bindings.Management$.MODULE$.onUninstalled());
        onEnabled = EventSourceImplicits$.MODULE$.eventAsEventSource1(chrome.management.bindings.Management$.MODULE$.onEnabled());
        onDisabled = EventSourceImplicits$.MODULE$.eventAsEventSource1(chrome.management.bindings.Management$.MODULE$.onDisabled());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Management$.class);
    }

    @Override
    public Set<Permission.API> requiredPermissions() {
        return requiredPermissions;
    }

    public EventSource<ExtensionInfo> onInstalled() {
        return onInstalled;
    }

    public EventSource<String> onUninstalled() {
        return onUninstalled;
    }

    public EventSource<ExtensionInfo> onEnabled() {
        return onEnabled;
    }

    public EventSource<ExtensionInfo> onDisabled() {
        return onDisabled;
    }

    public Future<Array<ExtensionInfo>> getAll() {
        Promise promise = Promise$.MODULE$.apply();
        chrome.management.bindings.Management$.MODULE$.getAll(extensions -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.getAll$$anonfun$2$$anonfun$1(extensions))));
        return promise.future();
    }

    public Future<ExtensionInfo> get(String id) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.management.bindings.Management$.MODULE$.get(id, extension -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.get$$anonfun$2$$anonfun$1(extension))));
        return promise.future();
    }

    public Future<ExtensionInfo> getSelf() {
        Promise promise = Promise$.MODULE$.apply();
        chrome.management.bindings.Management$.MODULE$.getSelf(self -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.getSelf$$anonfun$2$$anonfun$1(self))));
        return promise.future();
    }

    public Future<Array<String>> getPermissionWarningsById(String id) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.management.bindings.Management$.MODULE$.getPermissionWarningsById(id, warnings -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.getPermissionWarningsById$$anonfun$2$$anonfun$1(warnings))));
        return promise.future();
    }

    public Future<Array<String>> getPermissionWarningsByManifest(String manifestStr) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.management.bindings.Management$.MODULE$.getPermissionWarningsByManifest(manifestStr, warnings -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.getPermissionWarningsByManifest$$anonfun$2$$anonfun$1(warnings))));
        return promise.future();
    }

    public Future<Object> setEnabled(String id, boolean enabled) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.management.bindings.Management$.MODULE$.setEnabled(id, enabled, Any$.MODULE$.fromFunction0((Function0 & Serializable)() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.setEnabled$$anonfun$2$$anonfun$1(enabled)))));
        return promise.future();
    }

    public Future<BoxedUnit> uninstall(String id, Object options) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.management.bindings.Management$.MODULE$.uninstall(id, options, Any$.MODULE$.fromFunction0((Function0 & Serializable)() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            this.uninstall$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        }))));
        return promise.future();
    }

    public Object uninstall$default$2() {
        return package$.MODULE$.undefined();
    }

    public Future<BoxedUnit> uninstallSelf(Object options, Object callback) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.management.bindings.Management$.MODULE$.uninstallSelf(options, Any$.MODULE$.fromFunction0((Function0 & Serializable)() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            this.uninstallSelf$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        }))));
        return promise.future();
    }

    public Object uninstallSelf$default$1() {
        return package$.MODULE$.undefined();
    }

    public Object uninstallSelf$default$2() {
        return package$.MODULE$.undefined();
    }

    public Future<BoxedUnit> launchApp(String id) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.management.bindings.Management$.MODULE$.launchApp(id, Any$.MODULE$.fromFunction0((Function0 & Serializable)() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            this.launchApp$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        }))));
        return promise.future();
    }

    public Future<BoxedUnit> createAppShortcut(String id) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.management.bindings.Management$.MODULE$.createAppShortcut(id, Any$.MODULE$.fromFunction0((Function0 & Serializable)() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            this.createAppShortcut$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        }))));
        return promise.future();
    }

    public Future<BoxedUnit> setLaunchType(String id, String launchType) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.management.bindings.Management$.MODULE$.setLaunchType(id, launchType, Any$.MODULE$.fromFunction0((Function0 & Serializable)() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((Function0 & Serializable)() -> {
            this.setLaunchType$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        }))));
        return promise.future();
    }

    public Future<ExtensionInfo> generateAppForLink(String url, String title) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.management.bindings.Management$.MODULE$.generateAppForLink(url, title, Any$.MODULE$.fromFunction1((Function1 & Serializable)info -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue(() -> this.generateAppForLink$$anonfun$2$$anonfun$1(info)))));
        return promise.future();
    }

    private final Array getAll$$anonfun$2$$anonfun$1(Array extensions$1) {
        return extensions$1;
    }

    private final ExtensionInfo get$$anonfun$2$$anonfun$1(ExtensionInfo extension$1) {
        return extension$1;
    }

    private final ExtensionInfo getSelf$$anonfun$2$$anonfun$1(ExtensionInfo self$1) {
        return self$1;
    }

    private final Array getPermissionWarningsById$$anonfun$2$$anonfun$1(Array warnings$1) {
        return warnings$1;
    }

    private final Array getPermissionWarningsByManifest$$anonfun$2$$anonfun$1(Array warnings$2) {
        return warnings$2;
    }

    private final boolean setEnabled$$anonfun$2$$anonfun$1(boolean enabled$2) {
        return enabled$2;
    }

    private final void uninstall$$anonfun$2$$anonfun$1() {
    }

    private final void uninstallSelf$$anonfun$2$$anonfun$1() {
    }

    private final void launchApp$$anonfun$2$$anonfun$1() {
    }

    private final void createAppShortcut$$anonfun$2$$anonfun$1() {
    }

    private final void setLaunchType$$anonfun$2$$anonfun$1() {
    }

    private final ExtensionInfo generateAppForLink$$anonfun$2$$anonfun$1(ExtensionInfo info$1) {
        return info$1;
    }
}

