/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch.actor.exec;

import akka.actor.AbstractActor;
import com.aizuda.snailjob.client.model.DispatchRetryDTO;
import com.aizuda.snailjob.client.model.DispatchRetryResultDTO;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.model.SnailJobHeaders;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.dto.RetryLogMetaDTO;
import com.aizuda.snailjob.server.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.client.RetryRpcClient;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.context.MaxAttemptsPersistenceRetryContext;
import com.aizuda.snailjob.server.retry.task.support.retry.RetryExecutor;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="ExecUnitActor")
@Scope(value="prototype")
public class ExecUnitActor
extends AbstractActor {
    private static final Logger log = LoggerFactory.getLogger(ExecUnitActor.class);

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RetryExecutor.class, retryExecutor -> {
            MaxAttemptsPersistenceRetryContext context = (MaxAttemptsPersistenceRetryContext)retryExecutor.getRetryContext();
            RetryTask retryTask = context.getRetryTask();
            RegisterNodeInfo serverNode = context.getServerNode();
            RetrySceneConfig retrySceneConfig = context.getRetrySceneConfig();
            try {
                if (Objects.nonNull(serverNode)) {
                    retryExecutor.call(() -> {
                        Result<DispatchRetryResultDTO> result = this.callClient(retryTask, serverNode, retrySceneConfig);
                        if (StatusEnum.YES.getStatus().intValue() == result.getStatus()) {
                            DispatchRetryResultDTO data = (DispatchRetryResultDTO)JsonUtil.parseObject((String)JsonUtil.toJsonString((Object)result.getData()), DispatchRetryResultDTO.class);
                            result.setData((Object)data);
                        }
                        return result;
                    });
                }
            }
            catch (Exception e) {
                RetryLogMetaDTO retryLogMetaDTO = RetryTaskConverter.INSTANCE.toLogMetaDTO(retryTask);
                retryLogMetaDTO.setTimestamp(Long.valueOf(DateUtils.toNowMilli()));
                SnailJobLog.REMOTE.error("\u8bf7\u6c42\u5ba2\u6237\u7aef\u5f02\u5e38. <|>{}<|>", new Object[]{retryTask.getUniqueId(), retryLogMetaDTO, e});
            }
            finally {
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    private Result<DispatchRetryResultDTO> callClient(RetryTask retryTask, RegisterNodeInfo serverNode, RetrySceneConfig retrySceneConfig) {
        DispatchRetryDTO dispatchRetryDTO = new DispatchRetryDTO();
        dispatchRetryDTO.setIdempotentId(retryTask.getIdempotentId());
        dispatchRetryDTO.setScene(retryTask.getSceneName());
        dispatchRetryDTO.setExecutorName(retryTask.getExecutorName());
        dispatchRetryDTO.setArgsStr(retryTask.getArgsStr());
        dispatchRetryDTO.setUniqueId(retryTask.getUniqueId());
        dispatchRetryDTO.setRetryCount(retryTask.getRetryCount());
        dispatchRetryDTO.setGroupName(retryTask.getGroupName());
        dispatchRetryDTO.setNamespaceId(retryTask.getNamespaceId());
        SnailJobHeaders snailJobHeaders = new SnailJobHeaders();
        snailJobHeaders.setRetry(Boolean.TRUE.booleanValue());
        snailJobHeaders.setRetryId(retryTask.getUniqueId());
        RetryRpcClient rpcClient = (RetryRpcClient)RequestBuilder.newBuilder().nodeInfo(serverNode).failover(Boolean.TRUE.booleanValue()).allocKey(retryTask.getSceneName()).routeKey(retrySceneConfig.getRouteKey().intValue()).executorTimeout(retrySceneConfig.getExecutorTimeout()).client(RetryRpcClient.class).build();
        return rpcClient.dispatch(dispatchRetryDTO, snailJobHeaders);
    }
}

