/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.chatglm;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.BaseLlm;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.StreamResponseListener;
import com.agentsflex.core.llm.client.BaseLlmClientListener;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.client.impl.SseClient;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.store.VectorData;
import com.agentsflex.core.util.LogUtil;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.llm.chatglm.ChatglmLlmConfig;
import com.agentsflex.llm.chatglm.ChatglmLlmUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.HashMap;

public class ChatglmLlm
extends BaseLlm<ChatglmLlmConfig> {
    private HttpClient httpClient = new HttpClient();
    public AiMessageParser aiMessageParser = ChatglmLlmUtil.getAiMessageParser(false);
    public AiMessageParser aiStreamMessageParser = ChatglmLlmUtil.getAiMessageParser(true);

    public ChatglmLlm(ChatglmLlmConfig config) {
        super((LlmConfig)config);
    }

    public VectorData embed(Document document, EmbeddingOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", ChatglmLlmUtil.createAuthorizationToken((ChatglmLlmConfig)this.config));
        String endpoint = ((ChatglmLlmConfig)this.config).getEndpoint();
        String payload = Maps.of((String)"model", (Object)"embedding-2").set("input", (Object)document.getContent()).toJSON();
        String response = this.httpClient.post(endpoint + "/api/paas/v4/embeddings", headers, payload);
        if (((ChatglmLlmConfig)this.config).isDebug()) {
            LogUtil.println((String)(">>>>receive payload:" + response));
        }
        if (StringUtil.noText((String)response)) {
            return null;
        }
        VectorData vectorData = new VectorData();
        vectorData.setVector((double[])JSONPath.read((String)response, (String)"$.data[0].embedding", double[].class));
        return vectorData;
    }

    public AiMessageResponse chat(Prompt prompt, ChatOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", ChatglmLlmUtil.createAuthorizationToken((ChatglmLlmConfig)this.config));
        String endpoint = ((ChatglmLlmConfig)this.config).getEndpoint();
        String payload = ChatglmLlmUtil.promptToPayload(prompt, (ChatglmLlmConfig)this.config, false, options);
        String response = this.httpClient.post(endpoint + "/api/paas/v4/chat/completions", headers, payload);
        if (((ChatglmLlmConfig)this.config).isDebug()) {
            LogUtil.println((String)(">>>>receive payload:" + response));
        }
        if (StringUtil.noText((String)response)) {
            return AiMessageResponse.error((Prompt)prompt, (String)response, (String)"no content for response.");
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        JSONObject error = jsonObject.getJSONObject("error");
        AiMessageResponse messageResponse = new AiMessageResponse(prompt, response, (AiMessage)this.aiMessageParser.parse((Object)jsonObject));
        if (error != null && !error.isEmpty()) {
            messageResponse.setError(true);
            messageResponse.setErrorMessage(error.getString("message"));
            messageResponse.setErrorType(error.getString("type"));
            messageResponse.setErrorCode(error.getString("code"));
        }
        return messageResponse;
    }

    public void chatStream(Prompt prompt, StreamResponseListener listener, ChatOptions options) {
        SseClient llmClient = new SseClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", ChatglmLlmUtil.createAuthorizationToken((ChatglmLlmConfig)this.config));
        String payload = ChatglmLlmUtil.promptToPayload(prompt, (ChatglmLlmConfig)this.config, true, options);
        String endpoint = ((ChatglmLlmConfig)this.config).getEndpoint();
        BaseLlmClientListener clientListener = new BaseLlmClientListener((Llm)this, (LlmClient)llmClient, listener, prompt, this.aiStreamMessageParser);
        llmClient.start(endpoint + "/api/paas/v4/chat/completions", headers, payload, (LlmClientListener)clientListener, this.config);
    }
}

