/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.image.gitee;

import com.agentsflex.core.image.EditImageRequest;
import com.agentsflex.core.image.GenerateImageRequest;
import com.agentsflex.core.image.ImageModel;
import com.agentsflex.core.image.ImageResponse;
import com.agentsflex.core.image.VaryImageRequest;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.util.Maps;
import com.agentsflex.image.gitee.GiteeImageModelConfig;
import java.util.HashMap;

public class GiteeImageModel
implements ImageModel {
    private GiteeImageModelConfig config;
    private HttpClient httpClient = new HttpClient();

    public GiteeImageModel(GiteeImageModelConfig config) {
        this.config = config;
    }

    public ImageResponse generate(GenerateImageRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + this.config.getApiKey());
        String payload = Maps.of((String)"inputs", (Object)request.getPrompt()).setIfNotNull("width", (Object)request.getWidth()).setIfNotNull("height", (Object)request.getHeight()).toJSON();
        String url = this.config.getEndpoint() + "/api/serverless/" + this.config.getModel() + "/text-to-image";
        byte[] imageBytes = this.httpClient.postBytes(url, headers, payload);
        if (imageBytes == null || imageBytes.length == 0) {
            return ImageResponse.error((String)"can not read the image bytes.");
        }
        ImageResponse response = new ImageResponse();
        response.addImage(imageBytes);
        return response;
    }

    public ImageResponse img2imggenerate(GenerateImageRequest request) {
        return null;
    }

    public ImageResponse edit(EditImageRequest request) {
        throw new IllegalStateException("GiteeImageModel Can not support edit image.");
    }

    public ImageResponse vary(VaryImageRequest request) {
        throw new IllegalStateException("GiteeImageModel Can not support vary image.");
    }
}

