/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.prompt;

import com.agentsflex.core.llm.functions.Function;
import com.agentsflex.core.llm.functions.Parameter;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.message.FunctionCall;
import com.agentsflex.core.message.HumanMessage;
import com.agentsflex.core.message.Message;
import com.agentsflex.core.message.SystemMessage;
import com.agentsflex.core.message.ToolMessage;
import com.agentsflex.core.prompt.PromptFormat;
import com.agentsflex.core.util.Maps;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultPromptFormat
implements PromptFormat {
    @Override
    public Object toMessagesJsonObject(List<Message> messages) {
        if (messages == null || messages.isEmpty()) {
            return null;
        }
        ArrayList<Map<String, Object>> messageJsonArray = new ArrayList<Map<String, Object>>(messages.size());
        this.buildMessageJsonArray(messageJsonArray, messages);
        return messageJsonArray;
    }

    protected void buildMessageJsonArray(List<Map<String, Object>> messageJsonArray, List<Message> messages) {
        messages.forEach(message -> {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            if (message instanceof HumanMessage) {
                map.put("role", "user");
            } else if (message instanceof AiMessage) {
                map.put("role", "assistant");
                this.buildToolCalls(map, (AiMessage)message);
            } else if (message instanceof SystemMessage) {
                map.put("role", "system");
            } else if (message instanceof ToolMessage) {
                map.put("role", "tool");
                map.put("tool_call_id", ((ToolMessage)message).getToolCallId());
            }
            this.buildMessageContent((Message)message, (Map<String, Object>)map);
            messageJsonArray.add(map);
        });
    }

    protected void buildToolCalls(Map<String, Object> map, AiMessage aiMessage) {
        List<FunctionCall> calls = aiMessage.getCalls();
        if (calls != null && !calls.isEmpty()) {
            ArrayList<Maps> toolCalls = new ArrayList<Maps>();
            for (FunctionCall call : calls) {
                Maps toolCall = new Maps();
                toolCall.set("id", call.getId()).set("type", "function").set("function", Maps.of("name", call.getName()).set("arguments", this.buildToolCallsArguments(call.getArgs())));
                toolCalls.add(toolCall);
            }
            map.put("tool_calls", toolCalls);
        }
    }

    protected Object buildToolCallsArguments(Map<String, Object> arguments) {
        return JSON.toJSONString(arguments, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    protected void buildMessageContent(Message message, Map<String, Object> map) {
        map.put("content", message.getMessageContent());
    }

    @Override
    public Object toFunctionsJsonObject(Message message) {
        if (!(message instanceof HumanMessage)) {
            return null;
        }
        List<Function> functions = ((HumanMessage)message).getFunctions();
        if (functions == null || functions.isEmpty()) {
            return null;
        }
        ArrayList<Map<String, Object>> functionsJsonArray = new ArrayList<Map<String, Object>>();
        this.buildFunctionJsonArray(functionsJsonArray, functions);
        return functionsJsonArray;
    }

    protected void buildFunctionJsonArray(List<Map<String, Object>> functionsJsonArray, List<Function> functions) {
        for (Function function : functions) {
            HashMap<String, Object> functionRoot = new HashMap<String, Object>();
            functionRoot.put("type", "function");
            HashMap<String, Object> functionObj = new HashMap<String, Object>();
            functionRoot.put("function", functionObj);
            functionObj.put("name", function.getName());
            functionObj.put("description", function.getDescription());
            HashMap<String, Object> parametersObj = new HashMap<String, Object>();
            functionObj.put("parameters", parametersObj);
            parametersObj.put("type", "object");
            HashMap propertiesObj = new HashMap();
            parametersObj.put("properties", propertiesObj);
            ArrayList<String> requiredProperties = new ArrayList<String>();
            for (Parameter parameter : function.getParameters()) {
                HashMap<String, Object> parameterObj = new HashMap<String, Object>();
                parameterObj.put("type", parameter.getType());
                parameterObj.put("description", parameter.getDescription());
                parameterObj.put("enum", parameter.getEnums());
                if (parameter.isRequired()) {
                    requiredProperties.add(parameter.getName());
                }
                propertiesObj.put(parameter.getName(), parameterObj);
            }
            if (!requiredProperties.isEmpty()) {
                parametersObj.put("required", requiredProperties);
            }
            functionsJsonArray.add(functionRoot);
        }
    }
}

