/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.channels;

import co.paralleluniverse.common.monitoring.FlightRecorder;
import co.paralleluniverse.common.monitoring.FlightRecorderMessage;
import co.paralleluniverse.common.util.Debug;
import co.paralleluniverse.common.util.DelegatingEquals;
import co.paralleluniverse.common.util.Objects;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.remote.RemoteChannelProxyFactoryService;
import co.paralleluniverse.strands.Condition;
import co.paralleluniverse.strands.OwnedSynchronizer;
import co.paralleluniverse.strands.SimpleConditionSynchronizer;
import co.paralleluniverse.strands.Strand;
import co.paralleluniverse.strands.Synchronization;
import co.paralleluniverse.strands.Timeout;
import co.paralleluniverse.strands.channels.Channels;
import co.paralleluniverse.strands.channels.ProducerException;
import co.paralleluniverse.strands.channels.SelectAction;
import co.paralleluniverse.strands.channels.SelectActionImpl;
import co.paralleluniverse.strands.channels.Selectable;
import co.paralleluniverse.strands.channels.StandardChannel;
import co.paralleluniverse.strands.queues.BasicQueue;
import co.paralleluniverse.strands.queues.CircularBuffer;
import co.paralleluniverse.strands.queues.QueueCapacityExceededException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Instrumented
public abstract class QueueChannel<Message>
implements StandardChannel<Message>,
Selectable<Message>,
Synchronization,
Serializable {
    private static final int MAX_SEND_RETRIES = 10;
    final BasicQueue<Message> queue;
    private final boolean singleProducer;
    private final boolean singleConsumer;
    final Condition sync;
    final Condition sendersSync;
    final Channels.OverflowPolicy overflowPolicy;
    private Throwable closeException;
    private volatile boolean sendClosed;
    private boolean receiveClosed;
    public static final FlightRecorder RECORDER = Debug.isDebug() ? Debug.getGlobalFlightRecorder() : null;

    protected QueueChannel(BasicQueue<Message> queue, Channels.OverflowPolicy overflowPolicy, boolean singleConsumer) {
        this(queue, overflowPolicy, false, singleConsumer);
    }

    protected QueueChannel(BasicQueue<Message> queue, Channels.OverflowPolicy overflowPolicy, boolean singleProducer, boolean singleConsumer) {
        this.queue = queue;
        this.sync = !singleConsumer || queue instanceof CircularBuffer ? new SimpleConditionSynchronizer(this) : new OwnedSynchronizer(this);
        this.overflowPolicy = overflowPolicy;
        this.sendersSync = overflowPolicy == Channels.OverflowPolicy.BLOCK ? new SimpleConditionSynchronizer(this) : null;
        this.singleProducer = singleProducer;
        this.singleConsumer = singleConsumer;
    }

    public boolean equals(Object other) {
        if (other instanceof DelegatingEquals) {
            return other.equals(this);
        }
        return super.equals(other);
    }

    @Override
    public int capacity() {
        return this.queue.capacity();
    }

    @Override
    public boolean isSingleProducer() {
        return this.singleProducer;
    }

    @Override
    public boolean isSingleConsumer() {
        return this.singleConsumer;
    }

    public Channels.OverflowPolicy getOverflowPolicy() {
        return this.overflowPolicy;
    }

    protected Condition sync() {
        this.verifySync();
        return this.sync;
    }

    protected void signalReceivers() {
        QueueChannel.record("signalReceivers", "");
        this.sync.signalAll();
    }

    void signalSenders() {
        if (this.overflowPolicy == Channels.OverflowPolicy.BLOCK) {
            QueueChannel.record("signalSenders", "");
            this.sendersSync.signal();
        }
    }

    @Override
    public Object register(SelectAction<Message> action) {
        if (((SelectActionImpl)action).isData()) {
            if (this.sendersSync != null) {
                this.sendersSync.register();
            }
        } else {
            this.sync.register();
        }
        return action;
    }

    @Override
    public Object register() {
        return this.sync.register();
    }

    @Override
    public boolean tryNow(Object token) {
        boolean res;
        SelectActionImpl action = (SelectActionImpl)token;
        if (!action.lease()) {
            return false;
        }
        if (action.isData()) {
            res = this.trySend(action.message());
            if (res) {
                action.setItem(null);
            }
        } else {
            Message m = this.tryReceive();
            action.setItem(m);
            res = m == null ? this.isClosed() : true;
        }
        if (res) {
            action.won();
        } else {
            action.returnLease();
        }
        return res;
    }

    @Override
    public void unregister(Object token) {
        if (token == null) {
            return;
        }
        SelectActionImpl action = (SelectActionImpl)token;
        if (action.isData()) {
            if (this.sendersSync != null) {
                this.sendersSync.unregister(null);
            }
        } else {
            this.sync.unregister(null);
        }
    }

    @Override
    public boolean trySend(Message message) {
        if (message == null) {
            throw new IllegalArgumentException("message is null");
        }
        if (this.isSendClosed()) {
            return true;
        }
        if (this.queue.enq(message)) {
            this.signalReceivers();
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        if (!this.sendClosed) {
            this.sendClosed = true;
            this.signalReceivers();
            if (this.sendersSync != null) {
                this.sendersSync.signalAll();
            }
        }
    }

    @Override
    public void close(Throwable t) {
        if (!this.sendClosed) {
            this.closeException = t;
        }
        this.close();
    }

    public void sendNonSuspendable(Message message) throws QueueCapacityExceededException {
        if (this.isSendClosed()) {
            QueueChannel.record("sendNonSuspendable", "%s channel is closed for send. Dropping message %s", this, message);
            return;
        }
        QueueChannel.record("sendNonSuspendable", "%s enqueing message %s", this, message);
        if (!this.queue.enq(message)) {
            throw new QueueCapacityExceededException();
        }
        this.signalReceivers();
    }

    @Override
    public boolean isClosed() {
        if (this.receiveClosed) {
            return true;
        }
        if (this.sendClosed && this.queue.isEmpty()) {
            this.setReceiveClosed();
            return true;
        }
        return false;
    }

    boolean isSendClosed() {
        return this.sendClosed;
    }

    void setReceiveClosed() {
        this.receiveClosed = true;
    }

    protected Throwable getCloseException() {
        return this.closeException;
    }

    private Message closeValue() {
        if (this.closeException != null) {
            throw new ProducerException(this.closeException);
        }
        return null;
    }

    @Override
    public Message tryReceive() {
        if (this.receiveClosed) {
            return this.closeValue();
        }
        boolean closed = this.isSendClosed();
        Message m = this.queue.poll();
        if (m != null) {
            this.signalSenders();
        } else if (closed) {
            this.setReceiveClosed();
            return this.closeValue();
        }
        return m;
    }

    public Message receiveFromThread() throws InterruptedException {
        try {
            return this.receive();
        }
        catch (SuspendExecution ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public Message receiveFromThread(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            return this.receive(timeout, unit);
        }
        catch (SuspendExecution ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private void verifySync() {
        if (this.sync == null) {
            throw new IllegalStateException("Owning strand has not been set");
        }
    }

    public int getQueueLength() {
        return this.queue.size();
    }

    public String toString() {
        return "Channel{sync: " + this.sync + ", queue: " + Objects.systemToString(this.queue) + ", capacity: " + this.capacity() + '}';
    }

    protected Object writeReplace() throws ObjectStreamException {
        return RemoteChannelProxyFactoryService.create(this, null);
    }

    boolean isRecording() {
        return RECORDER != null;
    }

    static void record(String method, String format) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("QueueChannel", method, format, null));
        }
    }

    static void record(String method, String format, Object arg1) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("QueueChannel", method, format, new Object[]{arg1}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("QueueChannel", method, format, new Object[]{arg1, arg2}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2, Object arg3) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("QueueChannel", method, format, new Object[]{arg1, arg2, arg3}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("QueueChannel", method, format, new Object[]{arg1, arg2, arg3, arg4}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("QueueChannel", method, format, new Object[]{arg1, arg2, arg3, arg4, arg5}));
        }
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={109}, methodStart=107, methodEnd=112, methodOptimized=false)
    protected void signalAndWait() throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @Instrumented(suspendableCallSites={176}, methodStart=176, methodEnd=177, methodOptimized=true)
    public void send(Message message) throws SuspendExecution, InterruptedException {
        this.send0(message, false, false, 0L);
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(suspendableCallSites={181}, methodStart=181, methodEnd=181, methodOptimized=false)
    public boolean send(Message var1_1, long var2_2, TimeUnit var4_3) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(suspendableCallSites={186}, methodStart=186, methodEnd=186, methodOptimized=false)
    public boolean send(Message var1_1, Timeout var2_2) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Instrumented(suspendableCallSites={204}, methodStart=204, methodEnd=208, methodOptimized=true)
    protected void sendSync(Message message) throws SuspendExecution {
        try {
            this.send0(message, true, false, 0L);
        }
        catch (InterruptedException e) {
            Strand.currentStrand().interrupt();
        }
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={229, 245}, methodStart=211, methodEnd=248, methodOptimized=false)
    public boolean send0(Message var1_1, boolean var2_2, boolean var3_3, long var4_4) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={259, 261, 267, 269}, methodStart=252, methodEnd=272, methodOptimized=false)
    private boolean onQueueFull(int var1_1, boolean var2_2, long var3_3) throws SuspendExecution, InterruptedException, TimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(suspendableCallSites={369}, methodStart=354, methodEnd=375, methodOptimized=false)
    public Message receive() throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(suspendableCallSites={383, 403}, methodStart=380, methodEnd=415, methodOptimized=false)
    public Message receive(long var1_1, TimeUnit var3_2) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(suspendableCallSites={420}, methodStart=420, methodEnd=420, methodOptimized=false)
    public Message receive(Timeout var1_1) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

