/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.io;

import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.io.AsyncChannelGroup;
import co.paralleluniverse.fibers.io.FiberServerSocketChannel;
import co.paralleluniverse.fibers.io.FiberSocketChannel;
import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;

@Instrumented
public abstract class ChannelGroup {
    public static ChannelGroup withFixedThreadPool(int nThreads, ThreadFactory threadFactory) throws IOException {
        return new AsyncChannelGroup(AsynchronousChannelGroup.withFixedThreadPool(nThreads, threadFactory));
    }

    public static ChannelGroup withThreadPool(ExecutorService executor) throws IOException {
        return new AsyncChannelGroup(AsynchronousChannelGroup.withThreadPool(executor));
    }

    public abstract void shutdown();

    abstract FiberSocketChannel newFiberSocketChannel() throws IOException;

    abstract FiberServerSocketChannel newFiberServerSocketChannel() throws IOException;

    @Instrumented(suspendableCallSites={69}, methodStart=69, methodEnd=69, methodOptimized=true)
    static ChannelGroup defaultGroup() throws IOException, SuspendExecution {
        return AsyncChannelGroup.getDefaultGroup();
    }
}

