/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.util;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;

public final class Exceptions {
    public static RuntimeException rethrow(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    public static Throwable unwrap(Throwable t) {
        while (true) {
            if (t == null) {
                throw new NullPointerException();
            }
            if (t instanceof ExecutionException) {
                t = t.getCause();
                continue;
            }
            if (t instanceof InvocationTargetException) {
                t = t.getCause();
                continue;
            }
            if (!t.getClass().equals(RuntimeException.class) || t.getCause() == null) break;
            t = t.getCause();
        }
        return t;
    }

    public static RuntimeException rethrowUnwrap(Throwable t) {
        throw Exceptions.rethrow(Exceptions.unwrap(t));
    }

    public static <X extends Throwable> RuntimeException rethrowUnwrap(Throwable t, Class<X> exceptionClass) throws X {
        Throwable t1 = Exceptions.unwrap(t);
        if (exceptionClass.isInstance(t1)) {
            throw (Throwable)exceptionClass.cast(t1);
        }
        throw Exceptions.rethrow(t1);
    }

    public static <X1 extends Throwable, X2 extends Throwable> RuntimeException rethrowUnwrap(Throwable t, Class<X1> exceptionClass1, Class<X2> exceptionClass2) throws X1, X2 {
        Throwable t1 = Exceptions.unwrap(t);
        if (exceptionClass1.isInstance(t1)) {
            throw (Throwable)exceptionClass1.cast(t1);
        }
        if (exceptionClass2.isInstance(t1)) {
            throw (Throwable)exceptionClass2.cast(t1);
        }
        throw Exceptions.rethrow(t1);
    }

    public static RuntimeException sneakyThrow(Throwable t) {
        if (t == null) {
            throw new NullPointerException();
        }
        Exceptions.sneakyThrow0(t);
        return null;
    }

    private static <T extends Throwable> T sneakyThrow0(Throwable t) throws T {
        throw t;
    }

    private Exceptions() {
    }
}

