/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.onekeyshare.themes.classic;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.sharesdk.framework.CustomPlatform;
import cn.sharesdk.framework.Platform;
import cn.sharesdk.framework.ShareSDK;
import cn.sharesdk.onekeyshare.CustomerLogo;
import cn.sharesdk.onekeyshare.OnekeySharePage;
import cn.sharesdk.onekeyshare.OnekeyShareThemeImpl;
import cn.sharesdk.onekeyshare.themes.classic.ClassicTheme;
import cn.sharesdk.onekeyshare.themes.classic.IndicatorView;
import cn.sharesdk.onekeyshare.themes.classic.PlatformPageAdapter;
import com.mob.tools.gui.MobViewPager;
import com.mob.tools.gui.ViewPagerAdapter;
import com.mob.tools.utils.ResHelper;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class PlatformPage
extends OnekeySharePage {
    private ClassicTheme impl;
    private Runnable beforeFinish;
    private Animation animShow;
    private Animation animHide;
    private LinearLayout llPanel;
    private boolean finished;

    public PlatformPage(OnekeyShareThemeImpl impl) {
        super(impl);
        this.impl = (ClassicTheme)ResHelper.forceCast((Object)impl);
    }

    public void onCreate() {
        this.activity.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0x4C000000));
        this.initAnims();
        LinearLayout llPage = new LinearLayout((Context)this.activity);
        llPage.setOrientation(1);
        this.activity.setContentView((View)llPage);
        TextView vTop = new TextView((Context)this.activity);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
        lp.weight = 1.0f;
        vTop.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PlatformPage.this.finish();
            }
        });
        llPage.addView((View)vTop, (ViewGroup.LayoutParams)lp);
        this.llPanel = new LinearLayout((Context)this.activity);
        this.llPanel.setOrientation(1);
        lp = new LinearLayout.LayoutParams(-1, -2);
        this.llPanel.setAnimation(this.animShow);
        llPage.addView((View)this.llPanel, (ViewGroup.LayoutParams)lp);
        MobViewPager mvp = new MobViewPager((Context)this.activity);
        ArrayList<Object> cells = this.collectCells();
        PlatformPageAdapter adapter = this.newAdapter(cells);
        lp = new LinearLayout.LayoutParams(-1, adapter.getPanelHeight());
        this.llPanel.addView((View)mvp, (ViewGroup.LayoutParams)lp);
        IndicatorView vInd = new IndicatorView((Context)this.activity);
        lp = new LinearLayout.LayoutParams(-1, adapter.getBottomHeight());
        this.llPanel.addView((View)vInd, (ViewGroup.LayoutParams)lp);
        vInd.setScreenCount(adapter.getCount());
        vInd.onScreenChange(0, 0);
        adapter.setIndicator(vInd);
        mvp.setAdapter((ViewPagerAdapter)adapter);
    }

    protected abstract PlatformPageAdapter newAdapter(ArrayList<Object> var1);

    protected ArrayList<Object> collectCells() {
        HashMap<String, String> hides;
        ArrayList<Object> cells = new ArrayList<Object>();
        Platform[] platforms = ShareSDK.getPlatformList();
        if (platforms == null) {
            platforms = new Platform[]{};
        }
        if ((hides = this.getHiddenPlatforms()) == null) {
            hides = new HashMap();
        }
        for (Platform p : platforms) {
            if (hides.containsKey(p.getName()) || !this.isCanShare(p)) continue;
            cells.add(p);
        }
        ArrayList<CustomerLogo> customers = this.getCustomerLogos();
        if (customers != null && customers.size() > 0) {
            cells.addAll(customers);
        }
        return cells;
    }

    public final void showEditPage(final Platform platform) {
        this.beforeFinish = new Runnable(){

            @Override
            public void run() {
                boolean isSilent = PlatformPage.this.isSilent();
                boolean isCustomPlatform = platform instanceof CustomPlatform;
                boolean isUseClientToShare = PlatformPage.this.isUseClientToShare(platform);
                if (isSilent || isCustomPlatform || isUseClientToShare) {
                    PlatformPage.this.shareSilently(platform);
                } else {
                    Platform.ShareParams sp = PlatformPage.this.formateShareData(platform);
                    if (sp != null) {
                        ShareSDK.logDemoEvent((int)3, (Platform)platform);
                        sp.setOpenCustomEven(true);
                        if (PlatformPage.this.getCustomizeCallback() != null) {
                            PlatformPage.this.getCustomizeCallback().onShare(platform, sp);
                        }
                        PlatformPage.this.impl.showEditPage((Context)PlatformPage.this.activity, platform, sp);
                    }
                }
            }
        };
        this.finish();
    }

    public final void performCustomLogoClick(final View v, final CustomerLogo logo) {
        this.beforeFinish = new Runnable(){

            @Override
            public void run() {
                logo.listener.onClick(v);
            }
        };
        this.finish();
    }

    private boolean isCanShare(Platform platform) {
        String name = platform.getName();
        return !"Cmcc".equals(name) && !"Accountkit".equals(name) && !"Telecom".equals(name) && !"GooglePlus".equals(name);
    }

    private void initAnims() {
        this.animShow = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 1.0f, 1, 0.0f);
        this.animShow.setDuration(300L);
        this.animHide = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, 1.0f);
        this.animHide.setDuration(300L);
    }

    public boolean onFinish() {
        if (this.finished) {
            this.finished = false;
            return false;
        }
        this.animHide.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if (PlatformPage.this.beforeFinish == null) {
                    ShareSDK.logDemoEvent((int)2, null);
                } else {
                    PlatformPage.this.beforeFinish.run();
                    PlatformPage.this.beforeFinish = null;
                }
                PlatformPage.this.finished = true;
                PlatformPage.this.finish();
            }
        });
        this.llPanel.clearAnimation();
        this.llPanel.setAnimation(this.animHide);
        this.llPanel.setVisibility(8);
        return true;
    }
}

