/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.dfa;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.dfa.WordTree;
import cn.hutool.json.JSONUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;

public final class SensitiveUtil {
    public static final char DEFAULT_SEPARATOR = ',';
    private static WordTree sensitiveTree = new WordTree();

    public static boolean isInited() {
        return !sensitiveTree.isEmpty();
    }

    public static void init(final Collection<String> sensitiveWords, boolean isAsync) {
        if (isAsync) {
            ThreadUtil.execAsync(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    SensitiveUtil.init(sensitiveWords);
                    return true;
                }
            });
        } else {
            SensitiveUtil.init(sensitiveWords);
        }
    }

    public static void init(Collection<String> sensitiveWords) {
        sensitiveTree.clear();
        sensitiveTree.addWords(sensitiveWords);
    }

    public static void init(String sensitiveWords, char separator, boolean isAsync) {
        if (StrUtil.isNotBlank(sensitiveWords)) {
            SensitiveUtil.init(StrUtil.split((CharSequence)sensitiveWords, separator), isAsync);
        }
    }

    public static void init(String sensitiveWords, boolean isAsync) {
        SensitiveUtil.init(sensitiveWords, ',', isAsync);
    }

    public static boolean containsSensitive(String text) {
        return sensitiveTree.isMatch(text);
    }

    public static boolean containsSensitive(Object obj) {
        return sensitiveTree.isMatch(JSONUtil.toJsonStr(obj));
    }

    public static String getFindedFirstSensitive(String text) {
        return sensitiveTree.match(text);
    }

    public static String getFindedFirstSensitive(Object obj) {
        return sensitiveTree.match(JSONUtil.toJsonStr(obj));
    }

    public static List<String> getFindedAllSensitive(String text) {
        return sensitiveTree.matchAll(text);
    }

    public static List<String> getFindedAllSensitive(String text, boolean isDensityMatch, boolean isGreedMatch) {
        return sensitiveTree.matchAll(text, -1, isDensityMatch, isGreedMatch);
    }

    public static List<String> getFindedAllSensitive(Object bean) {
        return sensitiveTree.matchAll(JSONUtil.toJsonStr(bean));
    }

    public static List<String> getFindedAllSensitive(Object bean, boolean isDensityMatch, boolean isGreedMatch) {
        return SensitiveUtil.getFindedAllSensitive(JSONUtil.toJsonStr(bean), isDensityMatch, isGreedMatch);
    }
}

