<@pp.dropOutputFile />
<#import "../lib/lib.ftl" as lib/>
<#import "../lib/function.ftl" as fun/>
<#import "../lib/macro.ftl" as m>
<#list dalgen.xmlMappers as xmlMapper>
<@pp.changeOutputFile name = "/main/resources/${xmlMapper.doMapper.xmlPath}/${xmlMapper.doMapper.className}.xml" />
<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE mapper PUBLIC "-//mybatis.org//DTD Mapper 3.0//EN" "http://mybatis.org/dtd/mybatis-3-mapper.dtd" >
<mapper namespace="${xmlMapper.doMapper.packageName}.${xmlMapper.doMapper.className}">
    <!-- 自动生成,请修改 ${xmlMapper.table.sqlName}.xml -->
    <#-- 自定义分页时参数 limit {pageLimit}-->
    <#--生成BaseResultMap-->
<#if xmlMapper.table.columnList?size gt 0>
    <resultMap id="BaseResultMap"  type="${xmlMapper.doClass.packageName}.${xmlMapper.doClass.className}">
<#list xmlMapper.table.columnList as column>
        <#if column.sqlName?upper_case =="ID"><id column="${column.sqlName}" property="${column.javaName}" jdbcType="${column.sqlType}" javaType="${fun.javaTypeTrun(column.javaType)}"/><#else><result column="${column.sqlName}" property="${column.javaName}" jdbcType="${column.sqlType}" javaType="${fun.javaTypeTrun(column.javaType)}"/></#if>
</#list>
    </resultMap>
</#if>

    <#--生成自定义ResultMap-->
<#list xmlMapper.resultMaps as resultMap>
    <#assign extends = "">
    <#if resultMap.extend == "base">
        <#assign extends = "extends=\"BaseResultMap\"">
    </#if>
    <resultMap id="${resultMap.name}"  type="${resultMap.packageName}.${resultMap.className}" ${extends}>
    <#list resultMap.columnList as column>
        <#if column.sqlName?upper_case =="ID"><id column="${column.sqlName}" property="${column.javaName}"  javaType="${fun.javaTypeTrun(column.javaType)}"/><#else><result column="${column.sqlName}" property="${column.javaName}"  javaType="${fun.javaTypeTrun(column.javaType)}"/></#if>
    </#list>
    <#list resultMap.associations as association>
        <association property="${association.property}" column="${association.column}"  select="${lib.genDOMapperNameSpace(dalgen.doMappers,association.tableName)}.${association.methodName}"/>
    </#list>
    <#list resultMap.collections as collection>
        <collection property="${collection.property}" column="${collection.column}"  select="${lib.genDOMapperNameSpace(dalgen.doMappers,collection.tableName)}.${collection.methodName}"/>
    </#list>
    </resultMap>
</#list>

    <#if xmlMapper.sqlMap?size == 0 >
    <#-- baseSql -->
<#if xmlMapper.table.columnList?size gt 0>
    <sql id="Base_Column_List">
        <#list xmlMapper.table.columnList as column><#if column_index gt 0>,</#if>${column.sqlName}</#list>
    </sql>

    <#-- baseSql -->
    <sql id="Base_SF_Column_List">
        <#list xmlMapper.table.columnList as column><#if column_index gt 0>,</#if>sf.${column.sqlName}</#list>
    </sql>
</#if>
    <#else><#list xmlMapper.sqlMap?values as sqlXML>
    ${sqlXML}
    </#list>
    </#if>

    <#-- sql部分  -->
    <#list xmlMapper.cfTable.operations as operation>

<#if operation.multiplicity.code=="paging"><#--分页-->
    <#if operation.pagingCntType.code=="pagingCustom"><#--分页-->
    <!--${operation.remark!operation.name}-->
    <${lib.operation2Sql(operation.name)} id="${operation.name}Result" ${lib.mapperResult(operation)}${lib.timeout(operation)}>
    ${operation.cdata!}
    </${lib.operation2Sql(operation.name)}>
    <#else>
    <!--${operation.remark!operation.name} pageCount  mydalgen自动生成，请勿修改-->
    <${lib.operation2Sql(operation.name)} id="${operation.name}Count"  resultType="int"${lib.timeout(operation)}>
${operation.cdataPageCount!}
    </${lib.operation2Sql(operation.name)}>
    <!--${operation.remark!operation.name} pageResult  mydalgen自动生成，请勿修改-->
    <${lib.operation2Sql(operation.name)} id="${operation.name}Result"  ${lib.mapperResult(operation)}${lib.timeout(operation)}>
<#if dalgen.dbType?lower_case=="oracle">
    select
        *
    from(
${operation.cdata!}
    )
    where RN &gt; ${"#"}{startRow}
<#elseif dalgen.dbType?lower_case=="mysql">
${operation.cdata!}
        <#if operation.pagingCntType.code=="paging" || operation.pagingCntType.code=="pagingExtCnt">
        limit ${"#"}{startRow},${"#"}{limit}
        </#if>
</#if>
    </${lib.operation2Sql(operation.name)}>
        </#if>
    <#else><#--非分页-->
    <!--${operation.remark!operation.name}  mydalgen自动生成，请勿修改-->
    <${lib.operation2Sql(operation.name)} id="${operation.name}" ${lib.mapperResult(operation)}${lib.timeout(operation)} <#if operation.useGeneratedKeys??>useGeneratedKeys="${operation.useGeneratedKeys}"<#if operation.keyProperty??> keyProperty="${operation.keyProperty}"</#if></#if>>
<#if operation.autoGen>
<@m.autoGen operation.name ,xmlMapper.table/>
<#else>
${operation.cdata!}
</#if>
    </${lib.operation2Sql(operation.name)}>
</#if>
    </#list>
</mapper>
</#list>
