/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.gen.model.repository.db.database;

import cn.dalgen.mybatis.gen.model.repository.db.database.DataBaseInfoService;
import cn.dalgen.mybatis.gen.utils.CamelCaseUtils;
import cn.dalgen.mybatis.gen.utils.ConfigUtil;
import cn.dalgen.mybatis.gen.utils.ResultSetUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class OracleDataBaseInfoService
implements DataBaseInfoService {
    private static final String TABLE_COMMENT = "SELECT TABLE_NAME,TABLE_TYPE,COMMENTS as TABLE_COMMENT from USER_TAB_COMMENTS ";
    private static final String TABLE_CLOUMNS = "select  t.COLUMN_NAME,t.DATA_TYPE,t.COLUMN_ID as ORDINAL_POSITION,t.DATA_DEFAULT as COLUMN_DEFAULT,c.comments as COLUMN_COMMENT  ,t.DATA_LENGTH as C_LENGTH,t.DATA_PRECISION as C_PRECISION,t.DATA_SCALE as C_SCALE from user_tab_columns t  left join user_col_comments c on t.table_name = c.table_name and t.column_name = c.column_name  where t.table_name='${tableName}'   order by t.COLUMN_ID asc";
    public static final String TABLE_PRIMARY_KEY = "SELECT uc.column_name,au.index_name as PK_NAME FROM user_cons_columns uc JOIN user_constraints au ON uc.constraint_name=au.constraint_name WHERE au.constraint_type='P' AND au.table_name='${tableName}'";
    public static final String TABLE_INDEX = "SELECT ui.INDEX_NAME,uc.COLUMN_NAME,uc.COLUMN_POSITION FROM user_indexes ui JOIN user_ind_columns uc ON uc.table_name=ui.table_name AND uc.index_name=ui.index_name WHERE  ui.table_name='${tableName}' and  ui.uniqueness='${uniqueness}'  ORDER BY uc.column_position ASC";

    @Override
    public Map<String, String> getAllTableRemark(Connection connection) throws SQLException {
        HashMap result = Maps.newHashMap();
        PreparedStatement pstmt = connection.prepareStatement(TABLE_COMMENT);
        ResultSet resultSet = pstmt.executeQuery();
        while (resultSet.next()) {
            result.put(StringUtils.upperCase((String)resultSet.getString("TABLE_NAME")), resultSet.getString("TABLE_COMMENT"));
        }
        return result;
    }

    @Override
    public List<Map<String, String>> getAllColumnsByTableName(Connection connection, String tableName) throws SQLException {
        String sql = this.currSql(tableName, TABLE_CLOUMNS);
        PreparedStatement pstmt = connection.prepareStatement(sql);
        ResultSet resultSet = pstmt.executeQuery();
        ArrayList result = Lists.newArrayList();
        while (resultSet.next()) {
            HashMap columnMap = Maps.newHashMap();
            columnMap.put("ORDINAL_POSITION", resultSet.getString("ORDINAL_POSITION"));
            columnMap.put("COLUMN_NAME", ResultSetUtils.getRsStr(resultSet, "COLUMN_NAME"));
            columnMap.put("COLUMN_DEFAULT", ResultSetUtils.getRsStr(resultSet, "COLUMN_DEFAULT"));
            columnMap.put("COLUMN_COMMENT", ResultSetUtils.getRsStr(resultSet, "COLUMN_COMMENT"));
            columnMap.put("DATA_TYPE", ResultSetUtils.getRsStr(resultSet, "DATA_TYPE"));
            columnMap.put("C_LENGTH", ResultSetUtils.getRsStr(resultSet, "C_LENGTH"));
            columnMap.put("C_PRECISION", ResultSetUtils.getRsStr(resultSet, "C_PRECISION"));
            columnMap.put("C_SCALE", ResultSetUtils.getRsStr(resultSet, "C_SCALE"));
            result.add(columnMap);
        }
        return result;
    }

    @Override
    public Map<String, String> getPrimaryKeys(Connection connection, String tableName) throws SQLException {
        HashMap result = Maps.newHashMap();
        String sql = this.currSql(tableName, TABLE_PRIMARY_KEY);
        PreparedStatement pstmt = connection.prepareStatement(sql);
        ResultSet resultSet = pstmt.executeQuery();
        while (resultSet.next()) {
            String pkName = CamelCaseUtils.toCapitalizeCamelCase(ResultSetUtils.getRsStr(resultSet, "PK_NAME"));
            result.put(ResultSetUtils.getRsStr(resultSet, "COLUMN_NAME"), pkName);
        }
        return result;
    }

    @Override
    public Map<String, String> getUniqueIndexs(Connection connection, String tableName) throws SQLException {
        HashMap result = Maps.newHashMap();
        this.getDBIndex(connection, tableName, result, true);
        return result;
    }

    @Override
    public Map<String, String> getNormalIndexs(Connection connection, String tableName) throws SQLException {
        HashMap result = Maps.newHashMap();
        this.getDBIndex(connection, tableName, result, false);
        return result;
    }

    private void getDBIndex(Connection connection, String tableName, Map<String, String> result, boolean unique) throws SQLException {
        String sql = this.currSql(tableName, TABLE_INDEX);
        String _uniqueness = unique ? "UNIQUE" : "NONUNIQUE";
        sql = StringUtils.replace((String)sql, (String)"${uniqueness}", (String)_uniqueness);
        PreparedStatement pstmt = connection.prepareStatement(sql);
        ResultSet resultSet = pstmt.executeQuery();
        while (resultSet.next()) {
            String indexName = CamelCaseUtils.toCapitalizeCamelCase(ConfigUtil.getConfig().dealIndexName(ResultSetUtils.getRsStr(resultSet, "INDEX_NAME")));
            result.put(ResultSetUtils.getRsStr(resultSet, "COLUMN_NAME"), indexName);
        }
    }

    private String currSql(String tableName, String tablePrimaryKey) {
        String schema = ConfigUtil.getCurrentDb().getPropertyMapVal("schema");
        String sql = StringUtils.replace((String)tablePrimaryKey, (String)"${tableSchema}", (String)schema);
        sql = StringUtils.replace((String)sql, (String)"${tableName}", (String)StringUtils.upperCase((String)tableName));
        return sql;
    }
}

