/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.gen.model.repository.db.database;

import cn.dalgen.mybatis.gen.model.repository.db.database.DataBaseInfoService;
import cn.dalgen.mybatis.gen.utils.CamelCaseUtils;
import cn.dalgen.mybatis.gen.utils.ConfigUtil;
import cn.dalgen.mybatis.gen.utils.ResultSetUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MySqlDataBaseInfoService
implements DataBaseInfoService {
    private static final String table_comment = "SELECT table_name,table_comment FROM information_schema.TABLES where  table_type = 'BASE TABLE'";
    private static final String table_cloumns = "SELECT COLUMN_NAME,DATA_TYPE,COLUMN_COMMENT,ORDINAL_POSITION,COLUMN_DEFAULT,CHARACTER_MAXIMUM_LENGTH as C_LENGTH,NUMERIC_PRECISION as C_PRECISION,NUMERIC_SCALE as C_SCALE FROM INFORMATION_SCHEMA.Columns WHERE  table_name='${tableName}' AND table_schema='${tableSchema}' order by ordinal_position asc";

    @Override
    public Map<String, String> getAllTableRemark(Connection connection) throws SQLException {
        HashMap result = Maps.newHashMap();
        PreparedStatement pstmt = connection.prepareStatement(table_comment);
        ResultSet resultSet = pstmt.executeQuery();
        while (resultSet.next()) {
            result.put(StringUtils.upperCase((String)resultSet.getString("TABLE_NAME")), resultSet.getString("TABLE_COMMENT"));
        }
        return result;
    }

    @Override
    public List<Map<String, String>> getAllColumnsByTableName(Connection connection, String tableName) throws SQLException {
        String schema = ConfigUtil.getCurrentDb().getPropertyMapVal("schema");
        String sql = StringUtils.replace((String)table_cloumns, (String)"${tableSchema}", (String)schema);
        sql = StringUtils.replace((String)sql, (String)"${tableName}", (String)tableName);
        PreparedStatement pstmt = connection.prepareStatement(sql);
        ResultSet resultSet = pstmt.executeQuery();
        ArrayList result = Lists.newArrayList();
        while (resultSet.next()) {
            HashMap columnMap = Maps.newHashMap();
            columnMap.put("ORDINAL_POSITION", resultSet.getString("ORDINAL_POSITION"));
            columnMap.put("COLUMN_NAME", ResultSetUtils.getRsStr(resultSet, "COLUMN_NAME"));
            columnMap.put("COLUMN_DEFAULT", ResultSetUtils.getRsStr(resultSet, "COLUMN_DEFAULT"));
            columnMap.put("COLUMN_COMMENT", ResultSetUtils.getRsStr(resultSet, "COLUMN_COMMENT"));
            columnMap.put("DATA_TYPE", ResultSetUtils.getRsStr(resultSet, "DATA_TYPE"));
            columnMap.put("C_LENGTH", ResultSetUtils.getRsStr(resultSet, "C_LENGTH"));
            columnMap.put("C_PRECISION", ResultSetUtils.getRsStr(resultSet, "C_PRECISION"));
            columnMap.put("C_SCALE", ResultSetUtils.getRsStr(resultSet, "C_SCALE"));
            result.add(columnMap);
        }
        return result;
    }

    @Override
    public Map<String, String> getPrimaryKeys(Connection connection, String tableName) throws SQLException {
        HashMap result = Maps.newHashMap();
        ResultSet resultSet = connection.getMetaData().getPrimaryKeys(null, null, StringUtils.lowerCase((String)tableName));
        while (resultSet.next()) {
            String pkName = CamelCaseUtils.toCapitalizeCamelCase(ResultSetUtils.getRsStr(resultSet, "PK_NAME"));
            result.put(ResultSetUtils.getRsStr(resultSet, "COLUMN_NAME"), pkName);
        }
        return result;
    }

    @Override
    public Map<String, String> getUniqueIndexs(Connection connection, String tableName) throws SQLException {
        HashMap result = Maps.newHashMap();
        this.getDBIndex(connection, tableName, result, true);
        return result;
    }

    @Override
    public Map<String, String> getNormalIndexs(Connection connection, String tableName) throws SQLException {
        HashMap result = Maps.newHashMap();
        this.getDBIndex(connection, tableName, result, false);
        return result;
    }

    private void getDBIndex(Connection connection, String tableName, Map<String, String> result, boolean unique) throws SQLException {
        ResultSet indexResultSet = connection.getMetaData().getIndexInfo(null, null, StringUtils.lowerCase((String)tableName), true, false);
        while (indexResultSet.next()) {
            String uniqueName = CamelCaseUtils.toCapitalizeCamelCase(ConfigUtil.getConfig().dealIndexName(ResultSetUtils.getRsStr(indexResultSet, "INDEX_NAME")));
            result.put(ResultSetUtils.getRsStr(indexResultSet, "COLUMN_NAME"), uniqueName);
        }
    }
}

