/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.gen.model.repository.db;

import cn.dalgen.mybatis.gen.enums.TypeMapEnum;
import cn.dalgen.mybatis.gen.model.config.CfColumn;
import cn.dalgen.mybatis.gen.model.config.CfTable;
import cn.dalgen.mybatis.gen.model.dbtable.Column;
import cn.dalgen.mybatis.gen.model.dbtable.NormalIndex;
import cn.dalgen.mybatis.gen.model.dbtable.PrimaryKeys;
import cn.dalgen.mybatis.gen.model.dbtable.Table;
import cn.dalgen.mybatis.gen.model.dbtable.UniqueIndex;
import cn.dalgen.mybatis.gen.model.repository.db.database.DataBaseInfoHandler;
import cn.dalgen.mybatis.gen.utils.CamelCaseUtils;
import cn.dalgen.mybatis.gen.utils.ConfigUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class JDBCTableRepository {
    private static final Map<String, String> tableRemarkMap = Maps.newConcurrentMap();

    public Table gainTable(Connection connection, String tableName, CfTable cfTable) throws SQLException {
        String physicalName = cfTable == null ? tableName : cfTable.getPhysicalName();
        String logicName = tableName;
        for (String splitTableSuffix : ConfigUtil.getConfig().getSplitTableSuffixs()) {
            if (!StringUtils.endsWithIgnoreCase((String)tableName, (String)splitTableSuffix)) continue;
            logicName = StringUtils.replace((String)logicName, (String)splitTableSuffix, (String)"");
            break;
        }
        List<CfColumn> cfColumns = cfTable == null ? null : cfTable.getColumns();
        Table table = new Table();
        table.setSqlName(logicName);
        String _pre = "";
        for (String pre : ConfigUtil.getCurrentDb().getTablePrefixs().keySet()) {
            if (!StringUtils.startsWith((String)logicName, (String)StringUtils.upperCase((String)pre)) || pre.length() <= _pre.length()) continue;
            _pre = pre;
        }
        if (StringUtils.isNotBlank((String)_pre)) {
            String toTableName = ConfigUtil.getCurrentDb().getTablePrefixs().get(_pre) + StringUtils.substring((String)logicName, (int)_pre.length());
            table.setJavaName(CamelCaseUtils.toCapitalizeCamelCase(toTableName));
        }
        if (StringUtils.isBlank((String)table.getJavaName())) {
            table.setJavaName(CamelCaseUtils.toCapitalizeCamelCase(logicName));
        }
        table.setPhysicalName(physicalName);
        String tableRemark = this.queryTableRemark(connection, tableName, logicName);
        table.setRemark(tableRemark);
        this.fillColumns(physicalName, connection, table, cfColumns, cfTable);
        this.fillPrimaryUniqueIndexKeys(connection, physicalName, table);
        if (ConfigUtil.getConfig().getDeleteColumn() != null) {
            for (Column column : table.getColumnList()) {
                if (!StringUtils.equalsIgnoreCase((String)column.getSqlName(), (String)ConfigUtil.getConfig().getDeleteColumn().getName())) continue;
                table.setNeadSoftDelete(true);
                break;
            }
        }
        return table;
    }

    private String queryTableRemark(Connection connection, String tableName, String logicName) throws SQLException {
        String remark;
        if (MapUtils.isEmpty(tableRemarkMap)) {
            Map<String, String> dbTableRemarkMap = DataBaseInfoHandler.getDataBaseInfoService().getAllTableRemark(connection);
            tableRemarkMap.putAll(dbTableRemarkMap);
        }
        return StringUtils.isBlank((String)(remark = tableRemarkMap.get(StringUtils.upperCase((String)tableName)))) ? logicName : remark;
    }

    private void fillPrimaryUniqueIndexKeys(Connection connection, String tableName, Table table) throws SQLException {
        ArrayList pkNameList = Lists.newArrayList();
        ArrayList uniqueNameList = Lists.newArrayList();
        this.fillPrimaryKeys(connection, tableName, table, pkNameList);
        this.fillUniqueIndex(connection, tableName, table, pkNameList, uniqueNameList);
        this.fillNormalIndex(connection, tableName, table, pkNameList, uniqueNameList);
    }

    private void fillNormalIndex(Connection connection, String tableName, Table table, List<String> pkNameList, List<String> uniqueNameList) throws SQLException {
        ArrayList indexNameList = Lists.newArrayList();
        HashMap normalIndexMap = Maps.newHashMap();
        Map<String, String> dbNormalIndexMap = DataBaseInfoHandler.getDataBaseInfoService().getNormalIndexs(connection, tableName);
        for (Map.Entry<String, String> idxEntry : dbNormalIndexMap.entrySet()) {
            NormalIndex normalIndex;
            String indexName = idxEntry.getValue();
            if (pkNameList.contains(indexName) || uniqueNameList.contains(indexName)) continue;
            if (!indexNameList.contains(indexName)) {
                indexNameList.add(indexName);
            }
            if ((normalIndex = (NormalIndex)normalIndexMap.get(indexName)) == null) {
                normalIndex = new NormalIndex();
                normalIndexMap.put(indexName, normalIndex);
                table.addNormalIndex(normalIndex);
            }
            normalIndex.setIdxName(indexName);
            normalIndex.addColumn(table.getColumnByName(idxEntry.getKey()));
        }
    }

    private void fillUniqueIndex(Connection connection, String tableName, Table table, List<String> pkNameList, List<String> uniqueNameList) throws SQLException {
        Map<String, String> dbUniqueIndexMap = DataBaseInfoHandler.getDataBaseInfoService().getUniqueIndexs(connection, tableName);
        HashMap uniqueIndexMap = Maps.newHashMap();
        for (Map.Entry<String, String> ukEntry : dbUniqueIndexMap.entrySet()) {
            UniqueIndex uniqueIndex;
            String uniqueName = ukEntry.getValue();
            if (pkNameList.contains(uniqueName)) continue;
            if (!uniqueNameList.contains(uniqueName)) {
                uniqueNameList.add(uniqueName);
            }
            if ((uniqueIndex = (UniqueIndex)uniqueIndexMap.get(uniqueName)) == null) {
                uniqueIndex = new UniqueIndex();
                uniqueIndexMap.put(uniqueName, uniqueIndex);
                table.addUniqueIndex(uniqueIndex);
            }
            uniqueIndex.setUkName(uniqueName);
            uniqueIndex.addColumn(table.getColumnByName(ukEntry.getKey()));
        }
    }

    private void fillPrimaryKeys(Connection connection, String tableName, Table table, List<String> pkNameList) throws SQLException {
        Map<String, String> dbPrimaryKeyMaps = DataBaseInfoHandler.getDataBaseInfoService().getPrimaryKeys(connection, tableName);
        for (Map.Entry<String, String> pkEntry : dbPrimaryKeyMaps.entrySet()) {
            if (pkNameList.contains(pkEntry.getValue())) continue;
            pkNameList.add(pkEntry.getValue());
        }
        if (CollectionUtils.isNotEmpty(pkNameList)) {
            PrimaryKeys primaryKeys = new PrimaryKeys();
            String pkName = "";
            int pkCnt = dbPrimaryKeyMaps.keySet().size();
            for (String key : dbPrimaryKeyMaps.keySet()) {
                pkName = pkCnt == 1 ? CamelCaseUtils.toCapitalizeCamelCase(key) : dbPrimaryKeyMaps.get(key);
                primaryKeys.addColumn(table.getColumnByName(key));
            }
            primaryKeys.setPkName(pkName);
            table.setPrimaryKeys(primaryKeys);
        }
    }

    private void fillColumns(String tableName, Connection connection, Table table, List<CfColumn> cfColumns, CfTable cfTable) throws SQLException {
        List<Map<String, String>> dbColumnMaps = DataBaseInfoHandler.getDataBaseInfoService().getAllColumnsByTableName(connection, tableName);
        for (Map<String, String> dbColumnMap : dbColumnMaps) {
            Long ordinalPosition = Long.valueOf(dbColumnMap.get("ORDINAL_POSITION"));
            SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
            formate.format(new Date());
            if (cfTable != null && StringUtils.equals((String)formate.format(new Date()), (String)cfTable.getOrdinalEffectiveDay()) && cfTable.getOrdinalMaxPosition() < ordinalPosition) break;
            Column column = new Column();
            column.setSqlName(dbColumnMap.get("COLUMN_NAME"));
            column.setSqlType(TypeMapEnum.getByJdbcTypeWithOther(dbColumnMap.get("DATA_TYPE")).getJdbcType());
            column.setDefaultValue(dbColumnMap.get("COLUMN_DEFAULT"));
            column.setJavaName(CamelCaseUtils.toCamelCase(column.getSqlName()));
            column.setJavaType(this.getJavaType(column, cfColumns));
            column.setTestVal(this.getTestVal(column, cfColumns));
            column.setRemarks(dbColumnMap.get("COLUMN_COMMENT"));
            column.setOrdinalPosition(ordinalPosition);
            column.setLength(dbColumnMap.get("C_LENGTH"));
            column.setPrecision(dbColumnMap.get("C_PRECISION"));
            column.setScale(dbColumnMap.get("C_SCALE"));
            table.addColumn(column);
        }
    }

    private String getTestVal(Column column, List<CfColumn> cfColumns) {
        if (cfColumns != null && cfColumns.size() > 0) {
            for (CfColumn cfColumn : cfColumns) {
                if (!StringUtils.equalsIgnoreCase((String)column.getSqlName(), (String)cfColumn.getName())) continue;
                return cfColumn.getTestVal();
            }
        }
        return null;
    }

    private String getJavaType(Column column, List<CfColumn> cfColumns) {
        if (cfColumns != null && cfColumns.size() > 0) {
            for (CfColumn cfColumn : cfColumns) {
                if (!StringUtils.equalsIgnoreCase((String)column.getSqlName(), (String)cfColumn.getName())) continue;
                return cfColumn.getJavatype();
            }
        }
        String javaType = TypeMapEnum.getByJdbcTypeWithOther(column.getSqlType()).getJavaType();
        String custJavaType = ConfigUtil.getConfig().getTypeMap().get(javaType);
        return StringUtils.isBlank((String)custJavaType) ? javaType : custJavaType;
    }
}

