/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.gen.datasources;

import cn.dalgen.mybatis.gen.datasources.DalgenConnectionDriver;
import cn.dalgen.mybatis.gen.datasources.JdbcConnectionDriver;
import cn.dalgen.mybatis.gen.utils.ConfigUtil;
import java.sql.Connection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

public class DBConnectionFactory {
    private static final Log LOG = new SystemStreamLog();

    public static Connection getConnection() {
        Connection connection = null;
        try {
            LOG.debug((CharSequence)"==== init connection");
            if (StringUtils.equalsIgnoreCase((String)"mysql", (String)ConfigUtil.getCurrentDb().getType())) {
                JdbcConnectionDriver jdbcConnection = new JdbcConnectionDriver();
                connection = jdbcConnection.getConnection(ConfigUtil.getCurrentDb());
            } else if (StringUtils.equalsIgnoreCase((String)"oracle", (String)ConfigUtil.getCurrentDb().getType())) {
                JdbcConnectionDriver jdbcConnection = new JdbcConnectionDriver();
                connection = jdbcConnection.getConnection(ConfigUtil.getCurrentDb());
            } else if (StringUtils.equalsIgnoreCase((String)"tddl-mysql", (String)ConfigUtil.getCurrentDb().getType())) {
                DalgenConnectionDriver driver = (DalgenConnectionDriver)Class.forName("TDDL").newInstance();
                connection = driver.getConnection(ConfigUtil.getCurrentDb());
            } else {
                DalgenConnectionDriver driver = (DalgenConnectionDriver)Class.forName(ConfigUtil.getCurrentDb().getType()).newInstance();
                connection = driver.getConnection(ConfigUtil.getCurrentDb());
            }
            Validate.notNull((Object)connection, (String)"====connection error ");
        }
        catch (Exception e) {
            LOG.error((CharSequence)"", (Throwable)e);
        }
        ConfigUtil.getCurrentDb().setConnection(connection);
        return connection;
    }
}

