/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.gen.dataloaders;

import cn.dalgen.mybatis.gen.common.FileNameSelector;
import cn.dalgen.mybatis.gen.dataloaders.AbstractDalgenLoader;
import cn.dalgen.mybatis.gen.model.Gen;
import cn.dalgen.mybatis.gen.model.repository.TableRepository;
import cn.dalgen.mybatis.gen.utils.ConfigUtil;
import com.google.common.collect.Lists;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

public class DalgenTbLoader
extends AbstractDalgenLoader {
    private static final Log LOG = new SystemStreamLog();
    private TableRepository tableRepository = new TableRepository();

    @Override
    public void load(Gen gen, Connection connection, File tablesFile) throws SQLException {
        String cmd = ConfigUtil.getCmd();
        if (StringUtils.equals((String)StringUtils.trim((String)cmd), (String)"*")) {
            return;
        }
        ArrayList cmdTables = Lists.newArrayList((Object[])StringUtils.split((String)StringUtils.upperCase((String)cmd), (String)";"));
        ArrayList neadInitTables = Lists.newArrayList();
        ArrayList existsTables = Lists.newArrayList();
        for (File file : tablesFile.listFiles(new FileNameSelector("xml"))) {
            existsTables.add(this.file2DbName(file));
        }
        for (String cmdTable : cmdTables) {
            if (existsTables.contains(cmdTable) || !StringUtils.isNotBlank((String)cmdTable)) continue;
            neadInitTables.add(cmdTable);
        }
        if (neadInitTables.isEmpty()) {
            return;
        }
        ConfigUtil.setCmd("*");
        LOG.info((CharSequence)("\u5f00\u59cb\u521d\u59cb\u5316\u8868" + neadInitTables));
        for (String neadInitTable : neadInitTables) {
            LOG.info((CharSequence)("\u521d\u59cb\u5316\u8868:" + neadInitTable));
            gen.addTable(this.tableRepository.gainTable(connection, neadInitTable, null));
        }
    }
}

