/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.gen.dataloaders;

import cn.dalgen.mybatis.gen.datasources.DBConnectionFactory;
import cn.dalgen.mybatis.gen.model.Gen;
import cn.dalgen.mybatis.gen.utils.ConfigUtil;
import fmpp.Engine;
import fmpp.tdd.DataLoader;
import java.io.File;
import java.sql.Connection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractDalgenLoader
implements DataLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(Engine e, List args) throws Exception {
        Gen gen = new Gen();
        gen.setOutRoot(e.getOutputRoot().getAbsolutePath());
        gen.setDalgenRoot(ConfigUtil.dalgenPath);
        gen.setDataBaseName(ConfigUtil.getCurrentDb().getName());
        gen.setTablesPath(ConfigUtil.getCurrentDb().getName() + "Tables");
        File tablesFile = new File(gen.getDalgenRoot() + File.separator + gen.getTablesPath() + File.separator);
        if (!tablesFile.exists()) {
            tablesFile.mkdir();
        }
        try (Connection connection = null;){
            connection = DBConnectionFactory.getConnection();
            gen.setDbType(ConfigUtil.getCurrentDb().getType());
            gen.setConfig(ConfigUtil.getConfig());
            this.load(gen, connection, tablesFile);
        }
        return gen;
    }

    public abstract void load(Gen var1, Connection var2, File var3) throws Exception;

    protected String file2DbName(File tableFile) {
        return StringUtils.upperCase((String)StringUtils.substring((String)tableFile.getName(), (int)0, (int)tableFile.getName().indexOf(".")));
    }
}

