/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.gen.model.dbtable;

import cn.dalgen.mybatis.gen.model.dbtable.Column;
import cn.dalgen.mybatis.gen.model.dbtable.NormalIndex;
import cn.dalgen.mybatis.gen.model.dbtable.PrimaryKeys;
import cn.dalgen.mybatis.gen.model.dbtable.UniqueIndex;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Table {
    private String sqlName;
    private String javaName;
    private String remark;
    private List<Column> columnList = Lists.newArrayList();
    private PrimaryKeys primaryKeys;
    private List<UniqueIndex> uniqueIndexs = Lists.newArrayList();
    private List<NormalIndex> normalIndexs = Lists.newArrayList();
    private String physicalName;
    private boolean neadSoftDelete = false;

    public PrimaryKeys getPrimaryKeys() {
        return this.primaryKeys;
    }

    public void setPrimaryKeys(PrimaryKeys primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public String getSqlName() {
        return this.sqlName;
    }

    public void setSqlName(String sqlName) {
        this.sqlName = sqlName;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<Column> getColumnList() {
        Ordering<Column> typeOrdering = new Ordering<Column>(){

            public int compare(Column left, Column right) {
                if (StringUtils.equalsIgnoreCase((String)left.getSqlName(), (String)"ID")) {
                    return -1;
                }
                if (StringUtils.equalsIgnoreCase((String)right.getSqlName(), (String)"ID")) {
                    return 1;
                }
                int cr = this.compare(left.getJavaType(), right.getJavaType());
                return cr == 0 ? this.compare(left.getJavaName(), right.getJavaName()) : cr;
            }

            private int compare(String left, String right) {
                int cr = Ints.compare((int)left.length(), (int)right.length());
                return cr == 0 ? left.compareTo(right) : cr;
            }
        };
        return typeOrdering.sortedCopy(this.columnList);
    }

    public Column getColumnByName(String name) {
        for (Column column : this.columnList) {
            if (!StringUtils.equalsIgnoreCase((String)name, (String)column.getSqlName())) continue;
            return column;
        }
        return null;
    }

    public void addColumn(Column column) {
        this.columnList.add(column);
    }

    public void setColumnList(List<Column> columnList) {
        this.columnList = columnList;
    }

    public String getPhysicalName() {
        return this.physicalName;
    }

    public void setPhysicalName(String physicalName) {
        this.physicalName = physicalName;
    }

    public List<UniqueIndex> getUniqueIndexs() {
        return this.uniqueIndexs;
    }

    public void setUniqueIndexs(List<UniqueIndex> uniqueIndexs) {
        this.uniqueIndexs = uniqueIndexs;
    }

    public void addUniqueIndex(UniqueIndex uniqueIndex) {
        this.uniqueIndexs.add(uniqueIndex);
    }

    public List<NormalIndex> getNormalIndexs() {
        return this.normalIndexs;
    }

    public void setNormalIndexs(List<NormalIndex> normalIndexs) {
        this.normalIndexs = normalIndexs;
    }

    public void addNormalIndex(NormalIndex normalIndex) {
        this.normalIndexs.add(normalIndex);
    }

    public boolean isNeadSoftDelete() {
        return this.neadSoftDelete;
    }

    public void setNeadSoftDelete(boolean neadSoftDelete) {
        this.neadSoftDelete = neadSoftDelete;
    }
}

