/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.pubsub;

import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.codec.StringCodec;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.output.ReplayOutput;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.protocol.RedisCommand;
import com.lambdaworks.redis.pubsub.PubSubOutput;
import com.lambdaworks.redis.resource.ClientResources;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;

public class PubSubCommandHandler<K, V>
extends CommandHandler<K, V> {
    private final RedisCodec<K, V> codec;
    private final Deque<ReplayOutput<K, V>> queue = new ArrayDeque<ReplayOutput<K, V>>();
    private ResponseHeaderReplayOutput<K, V> replay;
    private PubSubOutput<K, V, V> output;

    public PubSubCommandHandler(ClientOptions clientOptions, ClientResources clientResources, RedisCodec<K, V> codec) {
        super(clientOptions, clientResources);
        this.codec = codec;
        this.output = new PubSubOutput(codec);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.replay = null;
        this.queue.clear();
        super.channelInactive(ctx);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer) {
        ReplayOutput<K, V> replay;
        if (!this.getStack().isEmpty()) {
            super.decode(ctx, buffer);
        }
        while ((replay = this.queue.poll()) != null) {
            replay.replay(this.output);
            ctx.fireChannelRead(this.output);
            this.output = new PubSubOutput(this.codec);
        }
        while (super.getStack().isEmpty() && buffer.isReadable()) {
            if (!this.rsm.decode(buffer, this.output)) {
                return;
            }
            ctx.fireChannelRead(this.output);
            this.output = new PubSubOutput(this.codec);
        }
        buffer.discardReadBytes();
    }

    @Override
    protected boolean canDecode(ByteBuf buffer) {
        return super.canDecode(buffer) && this.output.type() == null;
    }

    @Override
    protected boolean canComplete(RedisCommand<?, ?, ?> command) {
        if (PubSubCommandHandler.isPubSubMessage(this.replay)) {
            this.queue.add(this.replay);
            this.replay = null;
            return false;
        }
        return super.canComplete(command);
    }

    @Override
    protected void complete(RedisCommand<?, ?, ?> command) {
        if (this.replay != null && command.getOutput() != null) {
            try {
                this.replay.replay(command.getOutput());
            }
            catch (Exception e) {
                command.completeExceptionally(e);
            }
            this.replay = null;
        }
        super.complete(command);
    }

    private static boolean isPubSubMessage(ResponseHeaderReplayOutput replay) {
        if (replay == null) {
            return false;
        }
        String firstElement = replay.firstElement;
        if (replay.multiCount != null && firstElement != null) {
            if (replay.multiCount == 3 && firstElement.equalsIgnoreCase(PubSubOutput.Type.message.name())) {
                return true;
            }
            if (replay.multiCount == 4 && firstElement.equalsIgnoreCase(PubSubOutput.Type.pmessage.name())) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected CommandOutput<K, V, ?> getCommandOutput(RedisCommand<K, V, ?> command) {
        if (this.getStack().isEmpty() || command.getOutput() == null) {
            return super.getCommandOutput(command);
        }
        if (this.replay == null) {
            this.replay = new ResponseHeaderReplayOutput();
        }
        return this.replay;
    }

    @Override
    protected void afterComplete(ChannelHandlerContext ctx, RedisCommand<K, V, ?> command) {
        if (command.getOutput() instanceof PubSubOutput) {
            ctx.fireChannelRead(command.getOutput());
        }
    }

    static class ResponseHeaderReplayOutput<K, V>
    extends ReplayOutput<K, V> {
        Integer multiCount;
        String firstElement;

        ResponseHeaderReplayOutput() {
        }

        @Override
        public void set(ByteBuffer bytes) {
            if (this.firstElement == null && bytes != null && bytes.remaining() > 0) {
                bytes.mark();
                this.firstElement = StringCodec.ASCII.decodeKey(bytes);
                bytes.reset();
            }
            super.set(bytes);
        }

        @Override
        public void multi(int count) {
            if (this.multiCount == null) {
                this.multiCount = count;
            }
            super.multi(count);
        }
    }
}

