/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.AbstractNodeSelection;
import com.lambdaworks.redis.cluster.AsyncClusterConnectionProvider;
import com.lambdaworks.redis.cluster.ClusterConnectionProvider;
import com.lambdaworks.redis.cluster.ClusterDistributionChannelWriter;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class DynamicNodeSelection<API, CMD, K, V>
extends AbstractNodeSelection<API, CMD, K, V> {
    private final ClusterDistributionChannelWriter<K, V> writer;
    private final Predicate<RedisClusterNode> selector;
    private final ClusterConnectionProvider.Intent intent;
    private final Function<StatefulRedisConnection<K, V>, API> apiExtractor;

    public DynamicNodeSelection(ClusterDistributionChannelWriter<K, V> writer, Predicate<RedisClusterNode> selector, ClusterConnectionProvider.Intent intent, Function<StatefulRedisConnection<K, V>, API> apiExtractor) {
        this.selector = selector;
        this.intent = intent;
        this.writer = writer;
        this.apiExtractor = apiExtractor;
    }

    @Override
    protected CompletableFuture<StatefulRedisConnection<K, V>> getConnection(RedisClusterNode redisClusterNode) {
        RedisURI uri = redisClusterNode.getUri();
        AsyncClusterConnectionProvider async = (AsyncClusterConnectionProvider)((Object)this.writer.getClusterConnectionProvider());
        return async.getConnectionAsync(this.intent, uri.getHost(), uri.getPort());
    }

    @Override
    protected CompletableFuture<API> getApi(RedisClusterNode redisClusterNode) {
        return this.getConnection(redisClusterNode).thenApply(this.apiExtractor);
    }

    @Override
    protected List<RedisClusterNode> nodes() {
        return this.writer.getPartitions().getPartitions().stream().filter(this.selector).collect(Collectors.toList());
    }
}

