/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.newlog;

import androidx.annotation.NonNull;
import com.annimon.stream.function.Supplier;
import com.fshows.android.stark.newlog.FsLogAdapter;
import com.fshows.android.stark.newlog.FsPrinter;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FsLogPrinter
implements FsPrinter {
    private final ThreadLocal<String> localTag = new ThreadLocal();
    private final List<FsLogAdapter> logAdapters = new ArrayList<FsLogAdapter>();

    @Override
    public void addLogAdapter(@NonNull FsLogAdapter adapter) {
        this.logAdapters.add(adapter);
    }

    @Override
    public FsPrinter t(String tag) {
        if (tag != null) {
            this.localTag.set(tag);
        }
        return this;
    }

    @Override
    public void d(String message, Object ... args) {
        this.log(3, message, null, args);
    }

    @Override
    public void d(Object object) {
        this.log(3, object.toString(), null, new Object[0]);
    }

    @Override
    public void e(String message, Object ... args) {
        this.e(message, null, args);
    }

    @Override
    public void e(String message, Throwable throwable, Object ... args) {
        this.log(6, message, throwable, args);
    }

    @Override
    public void w(String message, Object ... args) {
        this.log(5, message, null, args);
    }

    @Override
    public void i(String message, Object ... args) {
        this.log(4, message, null, args);
    }

    @Override
    public void v(String message, Object ... args) {
        this.log(2, message, null, args);
    }

    @Override
    public void wtf(String message, Object ... args) {
        this.log(7, message, null, args);
    }

    @Override
    public void log(int priority, String tag, String message, Throwable throwable) {
        if (throwable != null && message != null) {
            message = message + " : " + throwable.getMessage();
        }
        if (throwable != null && message == null) {
            message = throwable.getMessage();
        }
        if (StringUtils.isEmpty((CharSequence)message)) {
            message = "Empty/NULL log message";
        }
        for (FsLogAdapter adapter : this.logAdapters) {
            if (!adapter.isLoggable(priority, tag)) continue;
            adapter.log(priority, tag, message);
        }
    }

    private synchronized void log(int priority, String msg, Throwable throwable, Object ... args) {
        this.log(priority, this.getTag(), this.createMessage(msg, args), throwable);
    }

    private String getTag() {
        String tag = this.localTag.get();
        if (tag != null) {
            this.localTag.remove();
            return tag;
        }
        return null;
    }

    private String format(String pattern, Object ... args) {
        return (String)Supplier.Util.safe(() -> {
            String pattern1 = pattern.replace("{{}}", "$$BRACE$$").replace("{}", "%s").replace("$$BRACE$$", "{}");
            return Strings.lenientFormat((String)pattern1, (Object[])args);
        }, (Object)"").get();
    }

    private String createMessage(String message, Object ... args) {
        return args == null || args.length == 0 ? message : this.format(message, args);
    }
}

