/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.compress;

import android.content.Context;
import com.fshows.android.stark.utils.FileUtil;
import java.io.File;

public class CompressBuilder {
    public static final String COMPRESS_CACHE_PATH = "compress";
    private int picWidth = 480;
    private int picHeight = 800;
    private int fileSize = 0x100000;
    private int quality = 100;
    private boolean isSizeCompress = true;
    public boolean isPic = true;
    private String uploadDir;
    private String destDir;

    public static CompressBuilder builder(Context mContext) {
        return new CompressBuilder(mContext);
    }

    public CompressBuilder(Context mContext) {
        this.destDir = FileUtil.getRootPath(mContext) + File.separator + COMPRESS_CACHE_PATH;
    }

    public CompressBuilder setPicWidth(int picWidth) {
        this.picWidth = picWidth;
        return this;
    }

    public CompressBuilder setPicHeight(int picHeight) {
        this.picHeight = picHeight;
        return this;
    }

    public CompressBuilder setMaxFileSize(int fileSize) {
        this.fileSize = fileSize;
        return this;
    }

    public CompressBuilder setQuality(int quality) {
        this.quality = quality;
        return this;
    }

    public CompressBuilder setUploadDir(String uploadDir) {
        this.uploadDir = uploadDir;
        return this;
    }

    public CompressBuilder setDestDir(String destDir) {
        this.destDir = destDir;
        return this;
    }

    public CompressBuilder setIsPic(boolean isPic) {
        this.isPic = isPic;
        return this;
    }

    public CompressBuilder setSizeCompress(boolean isSizeCompress) {
        this.isSizeCompress = isSizeCompress;
        return this;
    }

    public int getPicWidth() {
        return this.picWidth;
    }

    public int getPicHeight() {
        return this.picHeight;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public int getQuality() {
        return this.quality;
    }

    public String getUploadDir() {
        return this.uploadDir;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public boolean isPic() {
        return this.isPic;
    }

    public boolean isSizeCompress() {
        return this.isSizeCompress;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.picWidth).append(",").append(this.picHeight).append(",").append(this.fileSize).append(",").append(this.quality).append(",").append(this.uploadDir).append(",").append(this.isSizeCompress).append(",").append(this.destDir);
        return builder.toString();
    }
}

