/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.Log;
import androidx.core.content.FileProvider;
import com.fshows.android.stark.utils.FsLogUtil;
import com.fshows.android.stark.utils.PermissionHelper;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;

public class CommonUtil {
    private static final String TAG = CommonUtil.class.getSimpleName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String exec(String[] args) {
        String result;
        block11: {
            result = "";
            ProcessBuilder processBuilder = new ProcessBuilder(args);
            Process process = null;
            InputStream errIs = null;
            InputStream inIs = null;
            try {
                int read;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                process = processBuilder.start();
                errIs = process.getErrorStream();
                while ((read = errIs.read()) != -1) {
                    baos.write(read);
                }
                baos.write(10);
                inIs = process.getInputStream();
                while ((read = inIs.read()) != -1) {
                    baos.write(read);
                }
                byte[] data = baos.toByteArray();
                result = new String(data);
                CommonUtil.silentClose(errIs);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block11;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                CommonUtil.silentClose(errIs);
                CommonUtil.silentClose(inIs);
                if (process != null) {
                    process.destroy();
                }
            }
            CommonUtil.silentClose(inIs);
            if (process != null) {
                process.destroy();
            }
        }
        return result;
    }

    public static void silentClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("" + e.getMessage()));
            }
        }
    }

    public static void closeConnection(HttpURLConnection connection) {
        if (connection != null) {
            connection.disconnect();
        }
    }

    public static int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int dp2px(float dp) {
        return (int)(dp * Resources.getSystem().getDisplayMetrics().density + 0.5f);
    }

    public static int sp2px(float sp) {
        return (int)(sp * Resources.getSystem().getDisplayMetrics().scaledDensity + 0.5f);
    }

    public static int px2dp(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static void installApk(Context context, File apkFile) {
        Intent intent = new Intent("android.intent.action.VIEW");
        apkFile.setReadable(true, false);
        if (Build.VERSION.SDK_INT >= 24) {
            Uri contentUri = FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".fileprovider"), (File)apkFile);
            intent.addFlags(1);
            intent.setDataAndType(contentUri, "application/vnd.android.package-archive");
        } else {
            intent.setDataAndType(Uri.parse((String)("file://" + apkFile.getAbsolutePath())), "application/vnd.android.package-archive");
            intent.setFlags(0x10000000);
        }
        if (context.getPackageManager().queryIntentActivities(intent, 0).size() > 0) {
            context.startActivity(intent);
        }
    }

    public static void copyToClipboard(Context context, String text) {
        try {
            ClipboardManager clip = (ClipboardManager)context.getSystemService("clipboard");
            ClipData clipData = ClipData.newPlainText((CharSequence)"Label", (CharSequence)text);
            if (clip != null) {
                clip.setPrimaryClip(clipData);
            }
        }
        catch (Exception e) {
            FsLogUtil.debug(TAG, e.getMessage(), new Object[0]);
        }
    }

    public static void requestCallPhone(Activity activity, String phone) {
        CommonUtil.requestCallTelPhone(activity, "tel:" + phone);
    }

    public static void requestCallTelPhone(Activity activity, String telPhone) {
        PermissionHelper.getInstance(activity).requestCallPhone().subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                CommonUtil.callPhone((Context)activity, telPhone);
            }
        });
    }

    @SuppressLint(value={"MissingPermission"})
    private static void callPhone(Context mContext, String uriString) {
        Intent intent = new Intent("android.intent.action.CALL");
        Uri data = Uri.parse((String)uriString);
        intent.setData(data);
        mContext.startActivity(intent);
    }

    public static void requestSendSms(Activity activity, String phoneNum, String message) {
        PermissionHelper.getInstance(activity).requestSendSms().subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                CommonUtil.sendSms((Context)activity, phoneNum, message);
            }
        });
    }

    @SuppressLint(value={"MissingPermission"})
    private static void sendSms(Context mContext, String phoneNum, String message) {
        Intent intent = new Intent("android.intent.action.SENDTO");
        Uri data = Uri.parse((String)("smsto:" + phoneNum));
        intent.setData(data);
        intent.putExtra("sms_body", message);
        mContext.startActivity(intent);
    }

    public static boolean hasSimCard(Context context) {
        try {
            TelephonyManager telMgr = (TelephonyManager)context.getSystemService("phone");
            int simState = telMgr != null ? telMgr.getSimState() : 0;
            boolean result = true;
            switch (simState) {
                case 0: 
                case 1: {
                    result = false;
                    break;
                }
            }
            return result;
        }
        catch (Exception e) {
            return false;
        }
    }
}

