/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.crash.compat;

import android.app.ActivityManager;
import android.app.servertransaction.ClientTransaction;
import android.content.Intent;
import android.os.IBinder;
import android.os.Message;
import com.fshows.android.stark.crash.compat.IActivityKiller;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ActivityKillerV28
implements IActivityKiller {
    @Override
    public void finishLaunchActivity(Message message) {
        try {
            this.tryFinish1(message);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            try {
                this.tryFinish2(message);
                return;
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
                try {
                    this.tryFinish3(message);
                    return;
                }
                catch (Throwable throwable3) {
                    throwable3.printStackTrace();
                    return;
                }
            }
        }
    }

    private void tryFinish1(Message message) throws Throwable {
        ClientTransaction clientTransaction = (ClientTransaction)message.obj;
        IBinder binder = clientTransaction.getActivityToken();
        this.finish(binder);
    }

    private void tryFinish3(Message message) throws Throwable {
        Object clientTransaction = message.obj;
        Field mActivityTokenField = clientTransaction.getClass().getDeclaredField("mActivityToken");
        IBinder binder = (IBinder)mActivityTokenField.get(clientTransaction);
        this.finish(binder);
    }

    private void tryFinish2(Message message) throws Throwable {
        Object clientTransaction = message.obj;
        Method getActivityTokenMethod = clientTransaction.getClass().getDeclaredMethod("getActivityToken", new Class[0]);
        IBinder binder = (IBinder)getActivityTokenMethod.invoke(clientTransaction, new Object[0]);
        this.finish(binder);
    }

    @Override
    public void finishResumeActivity(Message message) {
    }

    @Override
    public void finishPauseActivity(Message message) {
    }

    @Override
    public void finishStopActivity(Message message) {
    }

    private void finish(IBinder binder) throws Exception {
        Method getServiceMethod = ActivityManager.class.getDeclaredMethod("getService", new Class[0]);
        Object activityManager = getServiceMethod.invoke(null, new Object[0]);
        Method finishActivityMethod = activityManager.getClass().getDeclaredMethod("finishActivity", IBinder.class, Integer.TYPE, Intent.class, Integer.TYPE);
        finishActivityMethod.setAccessible(true);
        int DONT_FINISH_TASK_WITH_ACTIVITY = 0;
        finishActivityMethod.invoke(activityManager, binder, 0, null, DONT_FINISH_TASK_WITH_ACTIVITY);
    }
}

