/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.net.Uri;
import android.os.Build;
import android.util.Base64;
import com.google.common.base.Strings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;

public class BitmapUtil {
    private static final String BASE64_PREFIX = "data:image/png;base64,";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveBitmap(Bitmap bitmap, File file) {
        if (bitmap == null) {
            return false;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
            fos.flush();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static boolean saveBitmap(Bitmap bitmap, String path) {
        return BitmapUtil.saveBitmap(bitmap, new File(path));
    }

    public static boolean saveBitmap(Bitmap bitmap, Uri uri) {
        try {
            File outFile = new File(new URI(uri.toString()));
            return BitmapUtil.saveBitmap(bitmap, outFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        float totalPixels = width * height;
        float totalReqPixelsCap = reqWidth * reqHeight * 2;
        while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixelsCap) {
            ++inSampleSize;
        }
        return inSampleSize;
    }

    public static Bitmap createRoundCornerBitmap(Bitmap bitmap) {
        int height = bitmap.getHeight();
        int width = bitmap.getHeight();
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, width, height);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(0);
        canvas.drawCircle((float)(width / 2), (float)(height / 2), (float)(width / 2), paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    public static Bitmap createBitmapThumbnail(Bitmap bitMap, boolean needRecycle, int newHeight, int newWidth) {
        int width = bitMap.getWidth();
        int height = bitMap.getHeight();
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newBitMap = Bitmap.createBitmap((Bitmap)bitMap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        if (needRecycle) {
            bitMap.recycle();
        }
        return newBitMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertFileToBase64(String srcPath) {
        if (Strings.isNullOrEmpty((String)srcPath)) {
            return null;
        }
        FileInputStream is = null;
        String result = null;
        try {
            is = new FileInputStream(srcPath);
            byte[] data = new byte[((InputStream)is).available()];
            ((InputStream)is).read(data);
            result = Base64.encodeToString((byte[])data, (int)0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != is) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (Strings.isNullOrEmpty(result)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(BASE64_PREFIX).append(result.replaceAll("\\s*", ""));
        return builder.toString();
    }

    public static byte[] convertBitmapToBytes(Bitmap bitmap) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        }
        return baos.toByteArray();
    }

    public static Bitmap scaleBitmap(Bitmap bitmap, int width, int height) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = (float)width / (float)w;
        float scaleHeight = (float)height / (float)h;
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)true);
    }

    public static int getBitmapSize(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 19) {
            return bitmap.getAllocationByteCount();
        }
        if (Build.VERSION.SDK_INT >= 12) {
            return bitmap.getByteCount();
        }
        return bitmap.getRowBytes() * bitmap.getHeight();
    }
}

