/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.transformers;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.fshows.android.parker.R;
import com.fshows.android.parker.transformers.OnTransformersItemClickListener;
import com.fshows.android.parker.transformers.OnTransformersScrollListener;
import com.fshows.android.parker.transformers.RecyclerViewScrollBar;
import com.fshows.android.parker.transformers.TransformersAdapter;
import com.fshows.android.parker.transformers.TransformersHolderCreator;
import com.fshows.android.parker.transformers.TransformersOptions;
import java.util.List;

public class TransformersLayout<T>
extends LinearLayout {
    private static final String TAG = TransformersLayout.class.getSimpleName();
    private static final int DEFAULT_SPAN_COUNT = 5;
    private static final int DEFAULT_LINES = 2;
    private static final int DEFAULT_SCROLL_BAR_WIDTH = 36;
    private static final int DEFAULT_SCROLL_BAR_HEIGHT = 3;
    private static final int DEFAULT_TRACK_COLOR = Color.parseColor((String)"#f0f0f0");
    private static final int DEFAULT_THUMB_COLOR = Color.parseColor((String)"#ffc107");
    private int columnSpan;
    private int rowSpan;
    private float scrollBarRadius;
    private int scrollBarTrackColor;
    private int scrollBarThumbColor;
    private int scrollBarTopMargin;
    private int scrollBarWidth;
    private int scrollBarHeight;
    private OnTransformersItemClickListener onTransformersItemClickListener;
    private RecyclerView recyclerView;
    private RecyclerViewScrollBar scrollBar;
    private OnTransformersScrollListener onScrollListener;
    private TransformersAdapter<T> transformersAdapter;
    private GridLayoutManager layoutManager;
    private Parcelable savedState;

    public TransformersLayout(Context context) {
        this(context, null);
    }

    public TransformersLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TransformersLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.parseAttrs(context, attrs);
        this.init(context);
    }

    @RequiresApi(api=21)
    public TransformersLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.parseAttrs(context, attrs);
        this.init(context);
    }

    private void parseAttrs(Context context, AttributeSet attrs) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.TransformersLayout);
        this.columnSpan = array.getInteger(R.styleable.TransformersLayout_tl_columnSpan, 5);
        this.rowSpan = array.getInteger(R.styleable.TransformersLayout_tl_rowSpan, 2);
        this.scrollBarRadius = array.getDimensionPixelSize(R.styleable.TransformersLayout_tl_scrollbarRadius, -1);
        this.scrollBarTrackColor = array.getColor(R.styleable.TransformersLayout_tl_scrollbarTrackColor, DEFAULT_TRACK_COLOR);
        this.scrollBarThumbColor = array.getColor(R.styleable.TransformersLayout_tl_scrollbarThumbColor, DEFAULT_THUMB_COLOR);
        this.scrollBarTopMargin = array.getDimensionPixelSize(R.styleable.TransformersLayout_tl_scrollbarMarginTop, 0);
        this.scrollBarWidth = array.getDimensionPixelSize(R.styleable.TransformersLayout_tl_scrollbarWidth, this.dp2px(36.0f));
        this.scrollBarHeight = array.getDimensionPixelSize(R.styleable.TransformersLayout_tl_scrollbarHeight, this.dp2px(3.0f));
        array.recycle();
        if (this.scrollBarRadius < 0.0f) {
            this.scrollBarRadius = (float)this.dp2px(3.0f) / 2.0f;
        }
        if (this.columnSpan <= 0) {
            this.columnSpan = 5;
        }
        if (this.rowSpan <= 0) {
            this.rowSpan = 2;
        }
    }

    private void init(Context context) {
        this.setOrientation(1);
        this.setGravity(1);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.recyclerView = new RecyclerView(context);
        this.recyclerView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.recyclerView.setOverScrollMode(2);
        this.recyclerView.setNestedScrollingEnabled(false);
        this.recyclerView.setHasFixedSize(true);
        RecyclerView.ItemAnimator itemAnimator = this.recyclerView.getItemAnimator();
        if (itemAnimator != null) {
            itemAnimator.setChangeDuration(0L);
        }
        this.transformersAdapter = new TransformersAdapter(context, this.recyclerView);
        this.transformersAdapter.setSpanCount(this.columnSpan);
        this.recyclerView.setAdapter(this.transformersAdapter);
        this.setupLittleRecyclerView();
        this.scrollBar = new RecyclerViewScrollBar(context);
        this.setupScrollBar();
        this.addView((View)this.recyclerView);
        this.addView(this.scrollBar);
    }

    private void setupLargeRecyclerView() {
        this.layoutManager = new GridLayoutManager(this.getContext(), this.rowSpan, 0, false){

            public boolean canScrollVertically() {
                return false;
            }
        };
        this.layoutManager.setUsingSpansToEstimateScrollbarDimensions(true);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
    }

    private void setupLittleRecyclerView() {
        this.layoutManager = new GridLayoutManager(this.getContext(), this.columnSpan, 1, false){

            public boolean canScrollHorizontally() {
                return false;
            }
        };
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
    }

    private void setupScrollBar() {
        this.scrollBar.setVisibility(8);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.scrollBarWidth, this.scrollBarHeight);
        params.topMargin = this.scrollBarTopMargin;
        this.scrollBar.setLayoutParams((ViewGroup.LayoutParams)params);
        this.scrollBar.setTrackColor(this.scrollBarTrackColor).setThumbColor(this.scrollBarThumbColor).setRadius(this.scrollBarRadius).applyChange();
    }

    public TransformersLayout<T> addOnTransformersItemClickListener(OnTransformersItemClickListener listener) {
        this.onTransformersItemClickListener = listener;
        return this;
    }

    public void load(List<T> data, TransformersHolderCreator<T> creator) {
        this.transformersAdapter.setOnTransformersItemClickListener(this.onTransformersItemClickListener);
        this.transformersAdapter.setHolderCreator(creator);
        this.transformersAdapter.setSpanCount(this.columnSpan);
        this.transformersAdapter.setData(data);
        this.toggleScrollBar(data);
    }

    public TransformersLayout<T> apply(@Nullable TransformersOptions options) {
        if (options != null) {
            this.columnSpan = options.columnSpan <= 0 ? this.columnSpan : options.columnSpan;
            this.rowSpan = options.rowSpan <= 0 ? this.rowSpan : options.rowSpan;
            this.scrollBarWidth = options.scrollBarWidth <= 0 ? this.scrollBarWidth : options.scrollBarWidth;
            this.scrollBarHeight = options.scrollBarHeight <= 0 ? this.scrollBarHeight : options.scrollBarHeight;
            this.scrollBarRadius = options.scrollBarRadius < 0.0f ? (float)this.scrollBarHeight / 2.0f : options.scrollBarRadius;
            this.scrollBarTopMargin = options.scrollBarTopMargin <= 0 ? this.scrollBarTopMargin : options.scrollBarTopMargin;
            this.scrollBarTrackColor = options.scrollBarTrackColor == 0 ? DEFAULT_TRACK_COLOR : options.scrollBarTrackColor;
            this.scrollBarThumbColor = options.scrollBarThumbColor == 0 ? DEFAULT_THUMB_COLOR : options.scrollBarThumbColor;
            this.setupScrollBar();
        }
        return this;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.savedState != null) {
            this.layoutManager.onRestoreInstanceState(this.savedState);
        }
        this.savedState = null;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.savedState = this.layoutManager.onSaveInstanceState();
    }

    public void notifyDataChanged(List<T> data) {
        if (this.transformersAdapter != null) {
            this.transformersAdapter.setData(data);
            this.scrollToStart();
        }
        this.toggleScrollBar(data);
        if (this.scrollBar.getVisibility() == 0) {
            this.scrollBar.computeScrollScale();
        }
    }

    public void scrollToStart() {
        this.scrollToStart(true);
    }

    public void scrollToStart(boolean smooth) {
        this.scrollBar.setScrollBySelf(true);
        if (this.recyclerView != null && this.recyclerView.computeHorizontalScrollOffset() > 0) {
            if (smooth) {
                this.recyclerView.smoothScrollToPosition(0);
            } else {
                this.recyclerView.scrollToPosition(0);
            }
        }
    }

    public TransformersLayout<T> addOnTransformersScrollListener(OnTransformersScrollListener listener) {
        this.onScrollListener = listener;
        if (this.scrollBar != null) {
            this.scrollBar.setOnTransformersScrollListener(this.onScrollListener);
        }
        return this;
    }

    private void toggleScrollBar(List<T> data) {
        if (this.columnSpan * this.rowSpan >= data.size()) {
            this.setupLittleRecyclerView();
            this.scrollBar.setVisibility(8);
        } else {
            this.setupLargeRecyclerView();
            this.scrollBar.setVisibility(0);
            this.scrollBar.attachRecyclerView(this.recyclerView);
        }
    }

    private int dp2px(float dp) {
        return (int)(this.getContext().getResources().getDisplayMetrics().density * dp + 0.5f);
    }
}

