/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.transformers;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.fshows.android.parker.transformers.OnTransformersItemClickListener;
import com.fshows.android.parker.transformers.TransformersHolder;
import com.fshows.android.parker.transformers.TransformersHolderCreator;
import com.jakewharton.rxbinding3.view.RxView;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class TransformersAdapter<T>
extends RecyclerView.Adapter<TransformersHolder<T>> {
    private Context mContext;
    private List<T> mData;
    private TransformersHolderCreator<T> holderCreator;
    private RecyclerView mRecyclerView;
    private int spanCount;
    private OnTransformersItemClickListener onTransformersItemClickListener;
    private int clickIntervalSec = 0;

    public void setOnTransformersItemClickListener(OnTransformersItemClickListener listener) {
        this.onTransformersItemClickListener = listener;
    }

    public void setOnTransformersItemClickListener(OnTransformersItemClickListener listener, int clickIntervalSec) {
        this.onTransformersItemClickListener = listener;
        this.clickIntervalSec = clickIntervalSec;
    }

    public TransformersAdapter(Context context, RecyclerView recyclerView) {
        this.mContext = context;
        this.mRecyclerView = recyclerView;
    }

    public void setData(List<T> data) {
        this.mData = data;
        this.notifyDataSetChanged();
    }

    public void setSpanCount(int spanCount) {
        this.spanCount = spanCount;
    }

    public void setHolderCreator(TransformersHolderCreator<T> creator) {
        this.holderCreator = creator;
    }

    @NonNull
    public TransformersHolder<T> onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        int layoutId = this.holderCreator.getLayoutId();
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(layoutId, parent, false);
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)itemView.getLayoutParams();
        params.width = this.mRecyclerView.getMeasuredWidth() / this.spanCount;
        return this.holderCreator.createHolder(itemView);
    }

    @SuppressLint(value={"CheckResult"})
    public void onBindViewHolder(@NonNull TransformersHolder<T> holder, int position) {
        if (this.clickIntervalSec >= 0) {
            RxView.clicks((View)holder.itemView).throttleFirst((long)this.clickIntervalSec, TimeUnit.SECONDS).subscribe(unit -> {
                if (this.onTransformersItemClickListener != null) {
                    this.onTransformersItemClickListener.onItemClick(position);
                }
            });
        } else {
            holder.itemView.setOnClickListener(view -> {
                if (this.onTransformersItemClickListener != null) {
                    this.onTransformersItemClickListener.onItemClick(position);
                }
            });
        }
        holder.bindData(this.mContext, this.mData.get(position));
    }

    public int getItemCount() {
        return this.mData == null ? 0 : this.mData.size();
    }
}

