/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.tablayout;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.appcompat.app.ActionBar;
import androidx.core.content.ContextCompat;
import androidx.core.util.Pools;
import androidx.core.view.ViewCompat;
import androidx.core.widget.TextViewCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.fshows.android.parker.R;
import com.fshows.android.parker.tablayout.AnimationUtils;
import com.fshows.android.parker.tablayout.DividerDrawable;
import com.fshows.android.parker.tablayout.TabItem;
import com.fshows.android.parker.tablayout.ThemeUtils;
import com.fshows.android.parker.tablayout.ValueAnimatorCompat;
import com.fshows.android.parker.tablayout.ViewUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XTabLayout
extends HorizontalScrollView {
    private static final int DEFAULT_HEIGHT_WITH_TEXT_ICON = 72;
    private static final int DEFAULT_GAP_TEXT_ICON = 8;
    private static final int INVALID_WIDTH = -1;
    private static final int DEFAULT_HEIGHT = 48;
    private static final int TAB_MIN_WIDTH_MARGIN = 56;
    private static final int FIXED_WRAP_GUTTER_MIN = 16;
    private static final int SELECTED_TAB_ADD_WIDTH = 20;
    private static final int MOTION_NON_ADJACENT_OFFSET = 24;
    private static final int ANIMATION_DURATION = 300;
    private static final Pools.Pool<Tab> sTabPool = new Pools.SynchronizedPool(16);
    private boolean xTabTextAllCaps = false;
    private boolean xTabDividerWidthWidthText = false;
    public static final int MODE_SCROLLABLE = 0;
    public static final int MODE_FIXED = 1;
    public static final int GRAVITY_FILL = 0;
    public static final int GRAVITY_CENTER = 1;
    private final ArrayList<Tab> mTabs = new ArrayList();
    private Tab mSelectedTab;
    private final SlidingTabStrip mTabStrip;
    private int mTabPaddingStart;
    private int mTabPaddingTop;
    private int mTabPaddingEnd;
    private int mTabPaddingBottom;
    private int mTabTextAppearance;
    private ColorStateList mTabTextColors;
    private float mTabTextSize = 0.0f;
    private boolean xTabTextBold;
    private float mTabSelectedTextSize = 0.0f;
    private boolean xTabTextSelectedBold;
    private float mTabTextMultiLineSize;
    private final int xTabBackgroundColor;
    private final int xTabSelectedBackgroundColor;
    private int mTabMaxWidth = Integer.MAX_VALUE;
    private final int mRequestedTabMinWidth;
    private final int mRequestedTabMaxWidth;
    private int xTabDisplayNum;
    private final int mScrollableTabMinWidth;
    private int mContentInsetStart;
    private int mTabGravity;
    private int mMode;
    private int dividerWidth;
    private int dividerHeight;
    private int dividerColor;
    private int dividerGravity;
    private OnTabSelectedListener mOnTabSelectedListener;
    private List<OnTabSelectedListener> mOnTabSelectedListenerList = new ArrayList<OnTabSelectedListener>();
    private ValueAnimatorCompat mScrollAnimator;
    private ViewPager mViewPager;
    private PagerAdapter mPagerAdapter;
    private DataSetObserver mPagerAdapterObserver;
    private TabLayoutOnPageChangeListener mPageChangeListener;
    private final Pools.Pool<TabView> mTabViewPool = new Pools.SimplePool(12);

    public XTabLayout(Context context) {
        this(context, null);
    }

    public XTabLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XTabLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        ThemeUtils.checkAppCompatTheme(context);
        this.setHorizontalScrollBarEnabled(false);
        this.mTabStrip = new SlidingTabStrip(context);
        super.addView((View)this.mTabStrip, 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1));
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.XTabLayout, defStyleAttr, R.style.Widget_Design_TabLayout);
        this.mTabStrip.setSelectedIndicatorHeight(a.getDimensionPixelSize(R.styleable.XTabLayout_xTabIndicatorHeight, this.dpToPx(2)));
        this.mTabStrip.setmSelectedIndicatorWidth(a.getDimensionPixelSize(R.styleable.XTabLayout_xTabIndicatorWidth, 0));
        this.mTabStrip.setSelectedIndicatorColor(a.getColor(R.styleable.XTabLayout_xTabIndicatorColor, 0));
        this.mTabPaddingEnd = this.mTabPaddingBottom = a.getDimensionPixelSize(R.styleable.XTabLayout_xTabPadding, 0);
        this.mTabPaddingTop = this.mTabPaddingBottom;
        this.mTabPaddingStart = this.mTabPaddingBottom;
        this.mTabPaddingStart = a.getDimensionPixelSize(R.styleable.XTabLayout_xTabPaddingStart, this.mTabPaddingStart);
        this.mTabPaddingTop = a.getDimensionPixelSize(R.styleable.XTabLayout_xTabPaddingTop, this.mTabPaddingTop);
        this.mTabPaddingEnd = a.getDimensionPixelSize(R.styleable.XTabLayout_xTabPaddingEnd, this.mTabPaddingEnd);
        this.mTabPaddingBottom = a.getDimensionPixelSize(R.styleable.XTabLayout_xTabPaddingBottom, this.mTabPaddingBottom);
        this.xTabTextAllCaps = a.getBoolean(R.styleable.XTabLayout_xTabTextAllCaps, false);
        this.mTabTextAppearance = a.getResourceId(R.styleable.XTabLayout_xTabTextAppearance, R.style.TextAppearance_Design_Tab);
        this.mTabTextSize = a.getDimensionPixelSize(R.styleable.XTabLayout_xTabTextSize, 0);
        this.xTabTextBold = a.getBoolean(R.styleable.XTabLayout_xTabTextBold, false);
        this.mTabSelectedTextSize = a.getDimensionPixelSize(R.styleable.XTabLayout_xTabSelectedTextSize, 0);
        this.xTabTextSelectedBold = a.getBoolean(R.styleable.XTabLayout_xTabTextSelectedBold, false);
        TypedArray ta = context.obtainStyledAttributes(this.mTabTextAppearance, R.styleable.TextAppearance);
        try {
            if (this.mTabTextSize == 0.0f) {
                this.mTabTextSize = ta.getDimensionPixelSize(R.styleable.TextAppearance_android_textSize, 0);
            }
            this.mTabTextColors = ta.getColorStateList(R.styleable.TextAppearance_android_textColor);
        }
        finally {
            ta.recycle();
        }
        if (a.hasValue(R.styleable.XTabLayout_xTabTextColor)) {
            this.mTabTextColors = a.getColorStateList(R.styleable.XTabLayout_xTabTextColor);
        }
        if (a.hasValue(R.styleable.XTabLayout_xTabSelectedTextColor)) {
            int selected = a.getColor(R.styleable.XTabLayout_xTabSelectedTextColor, 0);
            this.mTabTextColors = XTabLayout.createColorStateList(this.mTabTextColors.getDefaultColor(), selected);
        }
        this.xTabDisplayNum = a.getInt(R.styleable.XTabLayout_xTabDisplayNum, 0);
        this.mRequestedTabMinWidth = a.getDimensionPixelSize(R.styleable.XTabLayout_xTabMinWidth, -1);
        this.mRequestedTabMaxWidth = a.getDimensionPixelSize(R.styleable.XTabLayout_xTabMaxWidth, -1);
        this.xTabBackgroundColor = a.getColor(R.styleable.XTabLayout_xTabBackgroundColor, 0);
        this.xTabSelectedBackgroundColor = a.getColor(R.styleable.XTabLayout_xTabSelectedBackgroundColor, 0);
        this.mContentInsetStart = a.getDimensionPixelSize(R.styleable.XTabLayout_xTabContentStart, 0);
        this.mMode = a.getInt(R.styleable.XTabLayout_xTabMode, 1);
        this.mTabGravity = a.getInt(R.styleable.XTabLayout_xTabGravity, 0);
        this.dividerWidth = a.getDimensionPixelSize(R.styleable.XTabLayout_xTabDividerWidth, 0);
        this.dividerHeight = a.getDimensionPixelSize(R.styleable.XTabLayout_xTabDividerHeight, 0);
        this.dividerColor = a.getColor(R.styleable.XTabLayout_xTabDividerColor, -16777216);
        this.dividerGravity = a.getInteger(R.styleable.XTabLayout_xTabDividerGravity, 1);
        this.xTabDividerWidthWidthText = a.getBoolean(R.styleable.XTabLayout_xTabDividerWidthWidthText, false);
        a.recycle();
        Resources res = this.getResources();
        this.mTabTextMultiLineSize = res.getDimensionPixelSize(R.dimen.design_tab_text_size_2line);
        this.mScrollableTabMinWidth = res.getDimensionPixelSize(R.dimen.design_tab_scrollable_min_width);
        this.applyModeAndGravity();
        this.addDivider();
    }

    private void addDivider() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (XTabLayout.this.dividerWidth > 0) {
                    LinearLayout linearLayout = (LinearLayout)XTabLayout.this.getChildAt(0);
                    linearLayout.setShowDividers(2);
                    DividerDrawable dividerDrawable = new DividerDrawable(XTabLayout.this.getContext());
                    dividerDrawable.setDividerSize(XTabLayout.this.dividerWidth, XTabLayout.this.dividerHeight);
                    dividerDrawable.setColor(XTabLayout.this.dividerColor);
                    dividerDrawable.setGravity(XTabLayout.this.dividerGravity);
                    linearLayout.setDividerDrawable((Drawable)dividerDrawable);
                }
            }
        });
    }

    public void setDividerSize(int width, int height) {
        this.dividerWidth = width;
        this.dividerHeight = height;
        this.addDivider();
    }

    public void setDividerColor(int color2) {
        this.dividerColor = color2;
        this.addDivider();
    }

    public void setDividerGravity(int gravity) {
        this.dividerGravity = gravity;
        this.addDivider();
    }

    public void setAllCaps(boolean allCaps) {
        this.xTabTextAllCaps = allCaps;
    }

    public void setSelectedTabIndicatorColor(@ColorInt int color2) {
        this.mTabStrip.setSelectedIndicatorColor(color2);
    }

    public void setSelectedTabIndicatorHeight(int height) {
        this.mTabStrip.setSelectedIndicatorHeight(height);
    }

    public void setIndicatorType(int indicatorType) {
        this.mTabStrip.setIndicatorType(indicatorType);
    }

    public void setxTabDisplayNum(int xTabDisplayNum) {
        this.xTabDisplayNum = xTabDisplayNum;
    }

    public void setScrollPosition(int position, float positionOffset, boolean updateSelectedText) {
        this.setScrollPosition(position, positionOffset, updateSelectedText, true);
    }

    private void setScrollPosition(int position, float positionOffset, boolean updateSelectedText, boolean updateIndicatorPosition) {
        int roundedPosition = Math.round((float)position + positionOffset);
        if (roundedPosition < 0 || roundedPosition >= this.mTabStrip.getChildCount()) {
            return;
        }
        if (updateIndicatorPosition) {
            this.mTabStrip.setIndicatorPositionFromTabPosition(position, positionOffset);
        }
        if (this.mScrollAnimator != null && this.mScrollAnimator.isRunning()) {
            this.mScrollAnimator.cancel();
        }
        this.scrollTo(this.calculateScrollXForTab(position, positionOffset), 0);
        if (updateSelectedText) {
            this.setSelectedTabView(roundedPosition);
        }
    }

    private float getScrollPosition() {
        return this.mTabStrip.getIndicatorPosition();
    }

    public void addTab(@NonNull Tab tab) {
        this.addTab(tab, this.mTabs.isEmpty());
    }

    public void addTab(@NonNull Tab tab, int position) {
        this.addTab(tab, position, this.mTabs.isEmpty());
    }

    public void addTab(@NonNull Tab tab, boolean setSelected) {
        if (tab.mParent != this) {
            throw new IllegalArgumentException("Tab belongs to a different TabLayout.");
        }
        this.addTabView(tab, setSelected);
        this.configureTab(tab, this.mTabs.size());
        if (setSelected) {
            tab.select();
        }
    }

    public void addTab(@NonNull Tab tab, int position, boolean setSelected) {
        if (tab.mParent != this) {
            throw new IllegalArgumentException("Tab belongs to a different TabLayout.");
        }
        this.addTabView(tab, position, setSelected);
        this.configureTab(tab, position);
        if (setSelected) {
            tab.select();
        }
    }

    private void addTabFromItemView(@NonNull TabItem item) {
        Tab tab = this.newTab();
        if (item.mText != null) {
            tab.setText(item.mText);
        }
        if (item.mIcon != null) {
            tab.setIcon(item.mIcon);
        }
        if (item.mCustomLayout != 0) {
            tab.setCustomView(item.mCustomLayout);
        }
        this.addTab(tab);
    }

    public void setOnTabSelectedListener(OnTabSelectedListener onTabSelectedListener) {
        this.mOnTabSelectedListener = onTabSelectedListener;
    }

    public void addOnTabSelectedListener(OnTabSelectedListener onTabSelectedListener) {
        this.mOnTabSelectedListenerList.add(onTabSelectedListener);
    }

    @NonNull
    public Tab newTab() {
        Tab tab = (Tab)sTabPool.acquire();
        if (tab == null) {
            tab = new Tab();
        }
        tab.mParent = this;
        tab.mView = this.createTabView(tab);
        return tab;
    }

    public int getTabCount() {
        return this.mTabs.size();
    }

    @Nullable
    public Tab getTabAt(int index) {
        return index >= 0 && index < this.getTabCount() ? this.mTabs.get(index) : null;
    }

    public int getSelectedTabPosition() {
        return this.mSelectedTab != null ? this.mSelectedTab.getPosition() : -1;
    }

    public void removeTab(Tab tab) {
        if (tab.mParent != this) {
            throw new IllegalArgumentException("Tab does not belong to this TabLayout.");
        }
        this.removeTabAt(tab.getPosition());
    }

    public void removeTabAt(int position) {
        int selectedTabPosition = this.mSelectedTab != null ? this.mSelectedTab.getPosition() : 0;
        this.removeTabViewAt(position);
        Tab removedTab = this.mTabs.remove(position);
        if (removedTab != null) {
            removedTab.reset();
            sTabPool.release((Object)removedTab);
        }
        int newTabCount = this.mTabs.size();
        for (int i = position; i < newTabCount; ++i) {
            this.mTabs.get(i).setPosition(i);
        }
        if (selectedTabPosition == position) {
            this.selectTab(this.mTabs.isEmpty() ? null : this.mTabs.get(Math.max(0, position - 1)));
        }
    }

    public void removeAllTabs() {
        for (int i = this.mTabStrip.getChildCount() - 1; i >= 0; --i) {
            this.removeTabViewAt(i);
        }
        Iterator<Tab> i = this.mTabs.iterator();
        while (i.hasNext()) {
            Tab tab = i.next();
            i.remove();
            tab.reset();
            sTabPool.release((Object)tab);
        }
        this.mSelectedTab = null;
    }

    public void setTabMode(int mode) {
        if (mode != this.mMode) {
            this.mMode = mode;
            this.applyModeAndGravity();
        }
    }

    public int getTabMode() {
        return this.mMode;
    }

    public void setTabGravity(int gravity) {
        if (this.mTabGravity != gravity) {
            this.mTabGravity = gravity;
            this.applyModeAndGravity();
        }
    }

    public int getTabGravity() {
        return this.mTabGravity;
    }

    public void setTabTextColors(@Nullable ColorStateList textColor) {
        if (this.mTabTextColors != textColor) {
            this.mTabTextColors = textColor;
            this.updateAllTabs();
        }
    }

    @Nullable
    public ColorStateList getTabTextColors() {
        return this.mTabTextColors;
    }

    public void setTabTextColors(int normalColor, int selectedColor) {
        this.setTabTextColors(XTabLayout.createColorStateList(normalColor, selectedColor));
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager) {
        if (this.mViewPager != null && this.mPageChangeListener != null) {
            this.mViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this.mPageChangeListener);
        }
        if (viewPager != null) {
            PagerAdapter adapter = viewPager.getAdapter();
            if (adapter == null) {
                throw new IllegalArgumentException("ViewPager does not have a PagerAdapter set");
            }
            this.mViewPager = viewPager;
            if (this.mPageChangeListener == null) {
                this.mPageChangeListener = new TabLayoutOnPageChangeListener(this);
            }
            this.mPageChangeListener.reset();
            viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.mPageChangeListener);
            this.setOnTabSelectedListener(new ViewPagerOnTabSelectedListener(viewPager));
            this.setPagerAdapter(adapter, true);
        } else {
            this.mViewPager = null;
            this.setOnTabSelectedListener(null);
            this.setPagerAdapter(null, true);
        }
    }

    @Deprecated
    public void setTabsFromPagerAdapter(@Nullable PagerAdapter adapter) {
        this.setPagerAdapter(adapter, false);
    }

    public boolean shouldDelayChildPressedState() {
        return this.getTabScrollRange() > 0;
    }

    private int getTabScrollRange() {
        return Math.max(0, this.mTabStrip.getWidth() - this.getWidth() - this.getPaddingLeft() - this.getPaddingRight());
    }

    private void setPagerAdapter(@Nullable PagerAdapter adapter, boolean addObserver) {
        if (this.mPagerAdapter != null && this.mPagerAdapterObserver != null) {
            this.mPagerAdapter.unregisterDataSetObserver(this.mPagerAdapterObserver);
        }
        this.mPagerAdapter = adapter;
        if (addObserver && adapter != null) {
            if (this.mPagerAdapterObserver == null) {
                this.mPagerAdapterObserver = new PagerAdapterObserver();
            }
            adapter.registerDataSetObserver(this.mPagerAdapterObserver);
        }
        this.populateFromPagerAdapter();
    }

    private void populateFromPagerAdapter() {
        this.removeAllTabs();
        if (this.mPagerAdapter != null) {
            int curItem;
            int adapterCount = this.mPagerAdapter.getCount();
            for (int i = 0; i < adapterCount; ++i) {
                this.addTab(this.newTab().setText(this.mPagerAdapter.getPageTitle(i)), false);
            }
            if (this.mViewPager != null && adapterCount > 0 && (curItem = this.mViewPager.getCurrentItem()) != this.getSelectedTabPosition() && curItem < this.getTabCount()) {
                this.selectTab(this.getTabAt(curItem));
            }
        } else {
            this.removeAllTabs();
        }
    }

    private void updateAllTabs() {
        int z = this.mTabs.size();
        for (int i = 0; i < z; ++i) {
            this.mTabs.get(i).updateView();
        }
    }

    private TabView createTabView(@NonNull Tab tab) {
        TabView tabView;
        TabView tabView2 = tabView = this.mTabViewPool != null ? (TabView)((Object)this.mTabViewPool.acquire()) : null;
        if (tabView == null) {
            tabView = new TabView(this.getContext());
        }
        tabView.setTab(tab);
        tabView.setFocusable(true);
        tabView.setMinimumWidth(this.getTabMinWidth());
        return tabView;
    }

    private void configureTab(Tab tab, int position) {
        tab.setPosition(position);
        this.mTabs.add(position, tab);
        int count = this.mTabs.size();
        for (int i = position + 1; i < count; ++i) {
            this.mTabs.get(i).setPosition(i);
        }
    }

    private void addTabView(Tab tab, boolean setSelected) {
        TabView tabView = tab.mView;
        if (this.mTabSelectedTextSize != 0.0f) {
            tabView.post(() -> {
                int tabWidth = tabView.getWidth();
                String text = tabView.getText();
                if (!TextUtils.isEmpty((CharSequence)text)) {
                    Paint paint = new Paint();
                    paint.setTextSize(this.mTabSelectedTextSize);
                    Rect rect = new Rect();
                    paint.getTextBounds(text, 0, text.length(), rect);
                    if (tabWidth - rect.width() < this.dpToPx(20)) {
                        tabWidth = rect.width() + this.dpToPx(20);
                        ViewGroup.LayoutParams layoutParams = tabView.getLayoutParams();
                        layoutParams.width = tabWidth;
                        tabView.setLayoutParams(layoutParams);
                    }
                }
            });
        }
        this.mTabStrip.addView((View)tabView, (ViewGroup.LayoutParams)this.createLayoutParamsForTabs());
        if (setSelected) {
            tabView.setSelected(true);
        }
    }

    private void addTabView(Tab tab, int position, boolean setSelected) {
        TabView tabView = tab.mView;
        this.mTabStrip.addView((View)tabView, position, (ViewGroup.LayoutParams)this.createLayoutParamsForTabs());
        if (setSelected) {
            tabView.setSelected(true);
        }
    }

    public void addView(View child) {
        this.addViewInternal(child);
    }

    public void addView(View child, int index) {
        this.addViewInternal(child);
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        this.addViewInternal(child);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        this.addViewInternal(child);
    }

    private void addViewInternal(View child) {
        if (!(child instanceof TabItem)) {
            throw new IllegalArgumentException("Only TabItem instances can be added to TabLayout");
        }
        this.addTabFromItemView((TabItem)child);
    }

    private LinearLayout.LayoutParams createLayoutParamsForTabs() {
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -1);
        this.updateTabViewLayoutParams(lp);
        return lp;
    }

    private void updateTabViewLayoutParams(LinearLayout.LayoutParams lp) {
        if (this.mMode == 1 && this.mTabGravity == 0) {
            lp.width = 0;
            lp.weight = 1.0f;
        } else {
            lp.width = -2;
            lp.weight = 0.0f;
        }
    }

    private int dpToPx(int dps) {
        return Math.round(this.getResources().getDisplayMetrics().density * (float)dps);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int idealHeight = this.dpToPx(this.getDefaultHeight()) + this.getPaddingTop() + this.getPaddingBottom();
        switch (View.MeasureSpec.getMode((int)heightMeasureSpec)) {
            case -2147483648: {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)Math.min(idealHeight, View.MeasureSpec.getSize((int)heightMeasureSpec)), (int)0x40000000);
                break;
            }
            case 0: {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)idealHeight, (int)0x40000000);
                break;
            }
        }
        int specWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) != 0) {
            Log.w((String)"BBB", (String)("specWidth:" + specWidth));
            if (this.mPagerAdapter != null && this.xTabDisplayNum != 0) {
                if (this.mPagerAdapter.getCount() == 1 || this.xTabDisplayNum == 1) {
                    WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
                    this.mTabMaxWidth = wm.getDefaultDisplay().getWidth();
                } else {
                    this.mTabMaxWidth = this.mRequestedTabMaxWidth > 0 ? this.mRequestedTabMaxWidth : specWidth - this.dpToPx(56);
                }
            } else {
                this.mTabMaxWidth = this.mRequestedTabMaxWidth > 0 ? this.mRequestedTabMaxWidth : specWidth - this.dpToPx(56);
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getChildCount() == 1) {
            View child = this.getChildAt(0);
            boolean remeasure = false;
            switch (this.mMode) {
                case 0: {
                    remeasure = child.getMeasuredWidth() < this.getMeasuredWidth();
                    break;
                }
                case 1: {
                    remeasure = child.getMeasuredWidth() != this.getMeasuredWidth();
                    break;
                }
            }
            if (remeasure) {
                int childHeightMeasureSpec = XTabLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)child.getLayoutParams().height);
                int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    private void removeTabViewAt(int position) {
        TabView view = (TabView)this.mTabStrip.getChildAt(position);
        this.mTabStrip.removeViewAt(position);
        if (view != null) {
            view.reset();
            this.mTabViewPool.release((Object)view);
        }
        this.requestLayout();
    }

    private void animateToTab(int newPosition) {
        int targetScrollX;
        if (newPosition == -1) {
            return;
        }
        if (this.getWindowToken() == null || !ViewCompat.isLaidOut((View)this) || this.mTabStrip.childrenNeedLayout()) {
            this.setScrollPosition(newPosition, 0.0f, true);
            return;
        }
        int startScrollX = this.getScrollX();
        if (startScrollX != (targetScrollX = this.calculateScrollXForTab(newPosition, 0.0f))) {
            if (this.mScrollAnimator == null) {
                this.mScrollAnimator = ViewUtils.createAnimator();
                this.mScrollAnimator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
                this.mScrollAnimator.setDuration(300);
                this.mScrollAnimator.setUpdateListener(new ValueAnimatorCompat.AnimatorUpdateListener(){

                    @Override
                    public void onAnimationUpdate(ValueAnimatorCompat animator) {
                        XTabLayout.this.scrollTo(animator.getAnimatedIntValue(), 0);
                    }
                });
            }
            this.mScrollAnimator.setIntValues(startScrollX, targetScrollX);
            this.mScrollAnimator.start();
        }
        this.mTabStrip.animateIndicatorToPosition(newPosition, 300);
    }

    private void setSelectedTabView(int position) {
        int tabCount = this.mTabStrip.getChildCount();
        if (position < tabCount && !this.mTabStrip.getChildAt(position).isSelected()) {
            for (int i = 0; i < tabCount; ++i) {
                View child = this.mTabStrip.getChildAt(i);
                child.setSelected(i == position);
            }
        }
    }

    void selectTab(Tab tab) {
        this.selectTab(tab, true);
    }

    void selectTab(Tab tab, boolean updateIndicator) {
        if (this.mSelectedTab == tab) {
            if (this.mSelectedTab != null) {
                if (this.mOnTabSelectedListener != null) {
                    this.mOnTabSelectedListener.onTabReselected(this.mSelectedTab);
                }
                for (OnTabSelectedListener onTabSelectedListener : this.mOnTabSelectedListenerList) {
                    onTabSelectedListener.onTabReselected(this.mSelectedTab);
                }
                this.animateToTab(tab.getPosition());
            }
        } else {
            if (updateIndicator) {
                int newPosition;
                int n = newPosition = tab != null ? tab.getPosition() : -1;
                if (newPosition != -1) {
                    this.setSelectedTabView(newPosition);
                }
                if ((this.mSelectedTab == null || this.mSelectedTab.getPosition() == -1) && newPosition != -1) {
                    this.setScrollPosition(newPosition, 0.0f, true);
                } else {
                    this.animateToTab(newPosition);
                }
            }
            if (this.mSelectedTab != null) {
                if (this.mOnTabSelectedListener != null) {
                    this.mOnTabSelectedListener.onTabUnselected(this.mSelectedTab);
                }
                for (OnTabSelectedListener onTabSelectedListener : this.mOnTabSelectedListenerList) {
                    onTabSelectedListener.onTabUnselected(this.mSelectedTab);
                }
            }
            this.mSelectedTab = tab;
            if (this.mSelectedTab != null) {
                if (this.mOnTabSelectedListener != null) {
                    this.mOnTabSelectedListener.onTabSelected(this.mSelectedTab);
                }
                for (OnTabSelectedListener onTabSelectedListener : this.mOnTabSelectedListenerList) {
                    onTabSelectedListener.onTabSelected(this.mSelectedTab);
                }
            }
        }
    }

    private int calculateScrollXForTab(int position, float positionOffset) {
        if (this.mMode == 0) {
            View selectedChild = this.mTabStrip.getChildAt(position);
            View nextChild = position + 1 < this.mTabStrip.getChildCount() ? this.mTabStrip.getChildAt(position + 1) : null;
            int selectedWidth = selectedChild != null ? selectedChild.getWidth() : 0;
            int nextWidth = nextChild != null ? nextChild.getWidth() : 0;
            return selectedChild.getLeft() + (int)((float)(selectedWidth + nextWidth) * positionOffset * 0.5f) + selectedChild.getWidth() / 2 - this.getWidth() / 2;
        }
        return 0;
    }

    private void applyModeAndGravity() {
        int paddingStart = 0;
        if (this.mMode == 0) {
            paddingStart = Math.max(0, this.mContentInsetStart - this.mTabPaddingStart);
        }
        ViewCompat.setPaddingRelative((View)this.mTabStrip, (int)paddingStart, (int)0, (int)0, (int)0);
        switch (this.mMode) {
            case 1: {
                this.mTabStrip.setGravity(1);
                break;
            }
            case 0: {
                this.mTabStrip.setGravity(0x800003);
                break;
            }
        }
        this.updateTabViews(true);
    }

    private void updateTabViews(boolean requestLayout) {
        for (int i = 0; i < this.mTabStrip.getChildCount(); ++i) {
            View child = this.mTabStrip.getChildAt(i);
            child.setMinimumWidth(this.getTabMinWidth());
            this.updateTabViewLayoutParams((LinearLayout.LayoutParams)child.getLayoutParams());
            if (!requestLayout) continue;
            child.requestLayout();
        }
    }

    private static ColorStateList createColorStateList(int defaultColor, int selectedColor) {
        int[][] states = new int[2][];
        int[] colors = new int[2];
        int i = 0;
        states[i] = SELECTED_STATE_SET;
        colors[i] = selectedColor;
        states[++i] = EMPTY_STATE_SET;
        colors[i] = defaultColor;
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    private int getDefaultHeight() {
        boolean hasIconAndText = false;
        int count = this.mTabs.size();
        for (int i = 0; i < count; ++i) {
            Tab tab = this.mTabs.get(i);
            if (tab == null || tab.getIcon() == null || TextUtils.isEmpty((CharSequence)tab.getText())) continue;
            hasIconAndText = true;
            break;
        }
        return hasIconAndText ? 72 : 48;
    }

    private int getTabMinWidth() {
        if (this.mPagerAdapter != null && this.xTabDisplayNum != 0) {
            WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
            if (this.mPagerAdapter.getCount() == 1 || this.xTabDisplayNum == 1) {
                return wm.getDefaultDisplay().getWidth();
            }
            if (this.mPagerAdapter.getCount() < this.xTabDisplayNum) {
                return wm.getDefaultDisplay().getWidth() / this.mPagerAdapter.getCount();
            }
            return wm.getDefaultDisplay().getWidth() / this.xTabDisplayNum;
        }
        if (this.xTabDisplayNum != 0) {
            WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
            return wm.getDefaultDisplay().getWidth() / this.xTabDisplayNum;
        }
        if (this.mRequestedTabMinWidth != -1) {
            return this.mRequestedTabMinWidth;
        }
        return this.mMode == 0 ? this.mScrollableTabMinWidth : 0;
    }

    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return this.generateDefaultLayoutParams();
    }

    private int getTabMaxWidth() {
        return this.mTabMaxWidth;
    }

    private class PagerAdapterObserver
    extends DataSetObserver {
        private PagerAdapterObserver() {
        }

        public void onChanged() {
            XTabLayout.this.populateFromPagerAdapter();
        }

        public void onInvalidated() {
            XTabLayout.this.populateFromPagerAdapter();
        }
    }

    public static class ViewPagerOnTabSelectedListener
    implements OnTabSelectedListener {
        private final ViewPager mViewPager;

        public ViewPagerOnTabSelectedListener(ViewPager viewPager) {
            this.mViewPager = viewPager;
        }

        @Override
        public void onTabSelected(Tab tab) {
            this.mViewPager.setCurrentItem(tab.getPosition());
        }

        @Override
        public void onTabUnselected(Tab tab) {
        }

        @Override
        public void onTabReselected(Tab tab) {
        }
    }

    public static class TabLayoutOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private final WeakReference<XTabLayout> mTabLayoutRef;
        private int mPreviousScrollState;
        private int mScrollState;

        public TabLayoutOnPageChangeListener(XTabLayout tabLayout) {
            this.mTabLayoutRef = new WeakReference<XTabLayout>(tabLayout);
        }

        public void onPageScrollStateChanged(int state) {
            this.mPreviousScrollState = this.mScrollState;
            this.mScrollState = state;
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            XTabLayout tabLayout = (XTabLayout)((Object)this.mTabLayoutRef.get());
            if (tabLayout != null) {
                boolean updateText = this.mScrollState != 2 || this.mPreviousScrollState == 1;
                boolean updateIndicator = this.mScrollState != 2 || this.mPreviousScrollState != 0;
                tabLayout.setScrollPosition(position, positionOffset, updateText, updateIndicator);
            }
        }

        public void onPageSelected(int position) {
            XTabLayout tabLayout = (XTabLayout)((Object)this.mTabLayoutRef.get());
            if (tabLayout != null && tabLayout.getSelectedTabPosition() != position) {
                boolean updateIndicator = this.mScrollState == 0 || this.mScrollState == 2 && this.mPreviousScrollState == 0;
                tabLayout.selectTab(tabLayout.getTabAt(position), updateIndicator);
            }
        }

        private void reset() {
            this.mScrollState = 0;
            this.mPreviousScrollState = 0;
        }
    }

    private class SlidingTabStrip
    extends LinearLayout {
        private int mSelectedIndicatorHeight;
        private int mSelectedIndicatorWidth;
        private final Paint mSelectedIndicatorPaint;
        private int mSelectedPosition;
        private float mSelectionOffset;
        private int mIndicatorLeft;
        private int mIndicatorRight;
        private int mIndicatorType;
        private ValueAnimatorCompat mIndicatorAnimator;

        SlidingTabStrip(Context context) {
            super(context);
            this.mSelectedPosition = -1;
            this.mIndicatorLeft = -1;
            this.mIndicatorRight = -1;
            this.mIndicatorType = 1;
            this.setWillNotDraw(false);
            this.mSelectedIndicatorPaint = new Paint();
        }

        void setSelectedIndicatorColor(int color2) {
            if (this.mSelectedIndicatorPaint.getColor() != color2) {
                this.mSelectedIndicatorPaint.setColor(color2);
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }

        void setSelectedIndicatorHeight(int height) {
            if (this.mSelectedIndicatorHeight != height) {
                this.mSelectedIndicatorHeight = height;
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }

        void setmSelectedIndicatorWidth(int width) {
            if (this.mSelectedIndicatorWidth != width) {
                this.mSelectedIndicatorWidth = width;
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }

        public int getmSelectedIndicatorWidth() {
            return this.mSelectedIndicatorWidth;
        }

        public void setIndicatorType(int indicatorType) {
            this.mIndicatorType = indicatorType;
        }

        boolean childrenNeedLayout() {
            int z = this.getChildCount();
            for (int i = 0; i < z; ++i) {
                View child = this.getChildAt(i);
                if (child.getWidth() > 0) continue;
                return true;
            }
            return false;
        }

        void setIndicatorPositionFromTabPosition(int position, float positionOffset) {
            if (this.mIndicatorAnimator != null && this.mIndicatorAnimator.isRunning()) {
                this.mIndicatorAnimator.cancel();
            }
            this.mSelectedPosition = position;
            this.mSelectionOffset = positionOffset;
            this.updateIndicatorPosition();
        }

        float getIndicatorPosition() {
            return (float)this.mSelectedPosition + this.mSelectionOffset;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000) {
                return;
            }
            if (XTabLayout.this.mMode == 1 && XTabLayout.this.mTabGravity == 1) {
                int count = this.getChildCount();
                int largestTabWidth = 0;
                int z = count;
                for (int i = 0; i < z; ++i) {
                    View child = this.getChildAt(i);
                    if (child.getVisibility() != 0) continue;
                    largestTabWidth = Math.max(largestTabWidth, child.getMeasuredWidth());
                }
                if (largestTabWidth <= 0) {
                    return;
                }
                int gutter = XTabLayout.this.dpToPx(16);
                boolean remeasure = false;
                if (largestTabWidth * count <= this.getMeasuredWidth() - gutter * 2) {
                    for (int i = 0; i < count; ++i) {
                        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.getChildAt(i).getLayoutParams();
                        if (lp.width == largestTabWidth && lp.weight == 0.0f) continue;
                        lp.width = largestTabWidth;
                        lp.weight = 0.0f;
                        remeasure = true;
                    }
                } else {
                    XTabLayout.this.mTabGravity = 0;
                    XTabLayout.this.updateTabViews(false);
                    remeasure = true;
                }
                if (remeasure) {
                    super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                }
            }
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            super.onLayout(changed, l, t, r, b);
            if (this.mIndicatorAnimator != null && this.mIndicatorAnimator.isRunning()) {
                this.mIndicatorAnimator.cancel();
                long duration = this.mIndicatorAnimator.getDuration();
                this.animateIndicatorToPosition(this.mSelectedPosition, Math.round((1.0f - this.mIndicatorAnimator.getAnimatedFraction()) * (float)duration));
            } else {
                this.updateIndicatorPosition();
            }
        }

        private void updateIndicatorPosition() {
            int right;
            int left;
            View selectedTitle = this.getChildAt(this.mSelectedPosition);
            if (selectedTitle != null && selectedTitle.getWidth() > 0) {
                int maxWidth;
                left = selectedTitle.getLeft();
                right = selectedTitle.getRight();
                int haftWidth = 0;
                if (this.mSelectedIndicatorWidth == 0 && !XTabLayout.this.xTabDividerWidthWidthText) {
                    this.mSelectedIndicatorWidth = 0x101011F;
                }
                if (this.mSelectedIndicatorWidth != 0 && (maxWidth = this.mIndicatorRight - this.mIndicatorLeft) > this.mSelectedIndicatorWidth) {
                    haftWidth = (maxWidth - this.mSelectedIndicatorWidth) / 2;
                    left += haftWidth;
                    right -= haftWidth;
                }
                if (this.mSelectionOffset > 0.0f && this.mSelectedPosition < this.getChildCount() - 1) {
                    View nextTitle = this.getChildAt(this.mSelectedPosition + 1);
                    int nextLeft = nextTitle.getLeft() + haftWidth;
                    int nextRight = nextTitle.getRight() - haftWidth;
                    left = (int)(this.mSelectionOffset * (float)nextLeft + (1.0f - this.mSelectionOffset) * (float)left);
                    right = (int)(this.mSelectionOffset * (float)nextRight + (1.0f - this.mSelectionOffset) * (float)right);
                }
            } else {
                right = -1;
                left = -1;
            }
            this.setIndicatorPosition(left, right);
        }

        private void setIndicatorPosition(int left, int right) {
            if ((left += XTabLayout.this.mTabPaddingStart) != this.mIndicatorLeft || (right -= XTabLayout.this.mTabPaddingEnd) != this.mIndicatorRight) {
                this.mIndicatorLeft = left;
                this.mIndicatorRight = right;
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }

        void animateIndicatorToPosition(final int position, int duration) {
            int startRight;
            int startLeft;
            if (this.mIndicatorAnimator != null && this.mIndicatorAnimator.isRunning()) {
                this.mIndicatorAnimator.cancel();
            }
            boolean isRtl = ViewCompat.getLayoutDirection((View)this) == 1;
            View targetView = this.getChildAt(position);
            if (targetView == null) {
                this.updateIndicatorPosition();
                return;
            }
            final int targetLeft = targetView.getLeft();
            final int targetRight = targetView.getRight();
            if (Math.abs(position - this.mSelectedPosition) <= 1) {
                startLeft = this.mIndicatorLeft;
                startRight = this.mIndicatorRight;
            } else {
                int offset = XTabLayout.this.dpToPx(24);
                startLeft = position < this.mSelectedPosition ? (isRtl ? (startRight = targetLeft - offset) : (startRight = targetRight + offset)) : (isRtl ? (startRight = targetRight + offset) : (startRight = targetLeft - offset));
            }
            if (startLeft != targetLeft || startRight != targetRight) {
                ValueAnimatorCompat animator = this.mIndicatorAnimator = ViewUtils.createAnimator();
                animator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
                animator.setDuration(duration);
                animator.setFloatValues(0.0f, 1.0f);
                animator.setUpdateListener(new ValueAnimatorCompat.AnimatorUpdateListener(){

                    @Override
                    public void onAnimationUpdate(ValueAnimatorCompat animator) {
                        float fraction = animator.getAnimatedFraction();
                        SlidingTabStrip.this.setIndicatorPosition(AnimationUtils.lerp(startLeft, targetLeft, fraction), AnimationUtils.lerp(startRight, targetRight, fraction));
                    }
                });
                animator.setListener(new ValueAnimatorCompat.AnimatorListenerAdapter(){

                    @Override
                    public void onAnimationEnd(ValueAnimatorCompat animator) {
                        SlidingTabStrip.this.mSelectedPosition = position;
                        SlidingTabStrip.this.mSelectionOffset = 0.0f;
                    }
                });
                animator.start();
            }
        }

        public void draw(Canvas canvas) {
            super.draw(canvas);
            if (this.mIndicatorLeft >= 0 && this.mIndicatorRight > this.mIndicatorLeft) {
                int maxWidth;
                if (this.mSelectedIndicatorWidth != 0 && !XTabLayout.this.xTabDividerWidthWidthText) {
                    maxWidth = this.mIndicatorRight - this.mIndicatorLeft;
                    if (maxWidth > this.mSelectedIndicatorWidth) {
                        this.mIndicatorLeft += (maxWidth - this.mSelectedIndicatorWidth) / 2;
                        this.mIndicatorRight -= (maxWidth - this.mSelectedIndicatorWidth) / 2;
                    }
                } else {
                    maxWidth = this.mIndicatorRight - this.mIndicatorLeft;
                    if (maxWidth > XTabLayout.this.mSelectedTab.getTextWidth()) {
                        this.mIndicatorLeft += (maxWidth - XTabLayout.this.mSelectedTab.getTextWidth()) / 2;
                        this.mIndicatorRight -= (maxWidth - XTabLayout.this.mSelectedTab.getTextWidth()) / 2;
                    }
                }
                switch (this.mIndicatorType) {
                    case 2: {
                        RectF oval2 = new RectF((float)this.mIndicatorLeft, (float)(this.getHeight() - this.mSelectedIndicatorHeight), (float)this.mIndicatorRight, (float)this.getHeight());
                        canvas.drawRoundRect(oval2, (float)this.mSelectedIndicatorHeight, (float)this.mSelectedIndicatorHeight, this.mSelectedIndicatorPaint);
                        break;
                    }
                    case 3: {
                        RectF oval3 = new RectF((float)this.mIndicatorLeft, (float)(this.getHeight() - this.mSelectedIndicatorHeight / 2), (float)this.mIndicatorRight, (float)(this.getHeight() + this.mSelectedIndicatorHeight / 2));
                        canvas.drawRoundRect(oval3, (float)this.mSelectedIndicatorHeight, (float)this.mSelectedIndicatorHeight, this.mSelectedIndicatorPaint);
                        break;
                    }
                    default: {
                        canvas.drawRect((float)this.mIndicatorLeft, (float)(this.getHeight() - this.mSelectedIndicatorHeight), (float)this.mIndicatorRight, (float)this.getHeight(), this.mSelectedIndicatorPaint);
                    }
                }
            }
        }
    }

    class TabView
    extends LinearLayout
    implements View.OnLongClickListener {
        private Tab mTab;
        private TextView mTextView;
        private ImageView mIconView;
        private View mCustomView;
        private TextView mCustomTextView;
        private ImageView mCustomIconView;
        private int mDefaultMaxLines;

        public TabView(Context context) {
            super(context);
            this.mDefaultMaxLines = 2;
            ViewCompat.setPaddingRelative((View)this, (int)XTabLayout.this.mTabPaddingStart, (int)XTabLayout.this.mTabPaddingTop, (int)XTabLayout.this.mTabPaddingEnd, (int)XTabLayout.this.mTabPaddingBottom);
            this.setGravity(17);
            this.setOrientation(1);
            this.setClickable(true);
        }

        public String getText() {
            return this.mTextView.getText().toString();
        }

        public int getTextWidth() {
            if (TextUtils.isEmpty((CharSequence)this.mTextView.getText().toString())) {
                return 0;
            }
            Rect rect = new Rect();
            String content = this.mTextView.getText().toString();
            this.mTextView.getPaint().getTextBounds(content, 0, content.length(), rect);
            return rect.width();
        }

        public boolean performClick() {
            boolean value = super.performClick();
            if (this.mTab != null) {
                this.mTab.select();
                return true;
            }
            return value;
        }

        public void setSelected(boolean selected) {
            boolean changed = this.isSelected() != selected;
            super.setSelected(selected);
            if (!selected) {
                if (XTabLayout.this.xTabBackgroundColor != 0) {
                    this.setBackgroundColor(XTabLayout.this.xTabBackgroundColor);
                }
                this.mTextView.setTextSize(0, XTabLayout.this.mTabTextSize);
                if (XTabLayout.this.xTabTextBold) {
                    this.mTextView.setTypeface(Typeface.defaultFromStyle((int)1));
                } else {
                    this.mTextView.setTypeface(Typeface.defaultFromStyle((int)0));
                }
            }
            if (changed && selected) {
                if (XTabLayout.this.xTabSelectedBackgroundColor != 0) {
                    this.setBackgroundColor(XTabLayout.this.xTabSelectedBackgroundColor);
                }
                this.sendAccessibilityEvent(4);
                if (this.mTextView != null) {
                    this.mTextView.setSelected(selected);
                    if (XTabLayout.this.mTabSelectedTextSize != 0.0f) {
                        this.mTextView.setTextSize(0, XTabLayout.this.mTabSelectedTextSize);
                        if (XTabLayout.this.xTabTextSelectedBold) {
                            this.mTextView.setTypeface(Typeface.defaultFromStyle((int)1));
                        } else {
                            this.mTextView.setTypeface(Typeface.defaultFromStyle((int)0));
                        }
                    }
                }
                if (this.mIconView != null) {
                    this.mIconView.setSelected(selected);
                }
            }
        }

        @TargetApi(value=14)
        public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
            super.onInitializeAccessibilityEvent(event);
            event.setClassName((CharSequence)ActionBar.Tab.class.getName());
        }

        @TargetApi(value=14)
        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(info);
            info.setClassName((CharSequence)ActionBar.Tab.class.getName());
        }

        public void onMeasure(int origWidthMeasureSpec, int origHeightMeasureSpec) {
            int specWidthSize = View.MeasureSpec.getSize((int)origWidthMeasureSpec);
            int specWidthMode = View.MeasureSpec.getMode((int)origWidthMeasureSpec);
            int maxWidth = XTabLayout.this.getTabMaxWidth();
            int heightMeasureSpec = origHeightMeasureSpec;
            int widthMeasureSpec = maxWidth > 0 && (specWidthMode == 0 || specWidthSize > maxWidth) ? View.MeasureSpec.makeMeasureSpec((int)XTabLayout.this.mTabMaxWidth, (int)Integer.MIN_VALUE) : origWidthMeasureSpec;
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (this.mTextView != null) {
                Resources res = this.getResources();
                float textSize = XTabLayout.this.mTabTextSize;
                int maxLines = this.mDefaultMaxLines;
                if (this.mIconView != null && this.mIconView.getVisibility() == 0) {
                    maxLines = 1;
                } else if (this.mTextView != null && this.mTextView.getLineCount() > 1) {
                    textSize = XTabLayout.this.mTabTextMultiLineSize;
                }
                float curTextSize = this.mTextView.getTextSize();
                int curLineCount = this.mTextView.getLineCount();
                int curMaxLines = TextViewCompat.getMaxLines((TextView)this.mTextView);
                if (textSize != curTextSize || curMaxLines >= 0 && maxLines != curMaxLines) {
                    Layout layout2;
                    boolean updateTextView = true;
                    if (XTabLayout.this.mMode == 1 && textSize > curTextSize && curLineCount == 1 && ((layout2 = this.mTextView.getLayout()) == null || this.approximateLineWidth(layout2, 0, textSize) > (float)layout2.getWidth())) {
                        updateTextView = false;
                    }
                    if (updateTextView) {
                        if (this.mTextView.isSelected() && XTabLayout.this.mTabSelectedTextSize != 0.0f) {
                            this.mTextView.setTextSize(0, XTabLayout.this.mTabSelectedTextSize);
                        } else {
                            this.mTextView.setTextSize(0, XTabLayout.this.mTabTextSize);
                        }
                        this.mTextView.setMaxLines(maxLines);
                        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                    }
                }
            }
        }

        private void setTab(@Nullable Tab tab) {
            if (tab != this.mTab) {
                this.mTab = tab;
                this.update();
            }
        }

        private void reset() {
            this.setTab(null);
            this.setSelected(false);
        }

        final void update() {
            View custom;
            Tab tab = this.mTab;
            View view = custom = tab != null ? tab.getCustomView() : null;
            if (custom != null) {
                ViewParent customParent = custom.getParent();
                if (customParent != this) {
                    if (customParent != null) {
                        ((ViewGroup)customParent).removeView(custom);
                    }
                    this.addView(custom);
                }
                this.mCustomView = custom;
                if (this.mTextView != null) {
                    this.mTextView.setVisibility(8);
                }
                if (this.mIconView != null) {
                    this.mIconView.setVisibility(8);
                    this.mIconView.setImageDrawable(null);
                }
                this.mCustomTextView = (TextView)custom.findViewById(16908308);
                if (this.mCustomTextView != null) {
                    this.mDefaultMaxLines = TextViewCompat.getMaxLines((TextView)this.mCustomTextView);
                }
                this.mCustomIconView = (ImageView)custom.findViewById(16908294);
            } else {
                if (this.mCustomView != null) {
                    this.removeView(this.mCustomView);
                    this.mCustomView = null;
                }
                this.mCustomTextView = null;
                this.mCustomIconView = null;
            }
            if (this.mCustomView == null) {
                if (this.mIconView == null) {
                    ImageView iconView = (ImageView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.design_layout_tab_icon, (ViewGroup)this, false);
                    this.addView((View)iconView, 0);
                    this.mIconView = iconView;
                }
                if (this.mTextView == null) {
                    TextView textView = (TextView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.design_layout_tab_text, (ViewGroup)this, false);
                    this.addView((View)textView);
                    this.mTextView = textView;
                    this.mDefaultMaxLines = TextViewCompat.getMaxLines((TextView)this.mTextView);
                }
                this.mTextView.setTextAppearance(this.getContext(), XTabLayout.this.mTabTextAppearance);
                if (XTabLayout.this.mTabTextColors != null) {
                    this.mTextView.setTextColor(XTabLayout.this.mTabTextColors);
                }
                this.updateTextAndIcon(this.mTextView, this.mIconView);
            } else if (this.mCustomTextView != null || this.mCustomIconView != null) {
                this.updateTextAndIcon(this.mCustomTextView, this.mCustomIconView);
            }
        }

        private void updateTextAndIcon(@Nullable TextView textView, @Nullable ImageView iconView) {
            boolean hasText;
            CharSequence contentDesc;
            Drawable icon = this.mTab != null ? this.mTab.getIcon() : null;
            CharSequence text = this.mTab != null ? this.mTab.getText() : null;
            CharSequence charSequence = contentDesc = this.mTab != null ? this.mTab.getContentDescription() : null;
            if (iconView != null) {
                if (icon != null) {
                    iconView.setImageDrawable(icon);
                    iconView.setVisibility(0);
                    this.setVisibility(0);
                } else {
                    iconView.setVisibility(8);
                    iconView.setImageDrawable(null);
                }
                iconView.setContentDescription(contentDesc);
            }
            boolean bl = hasText = !TextUtils.isEmpty((CharSequence)text);
            if (textView != null) {
                if (hasText) {
                    textView.setAllCaps(XTabLayout.this.xTabTextAllCaps);
                    textView.setText(text);
                    textView.setVisibility(0);
                    this.setVisibility(0);
                } else {
                    textView.setVisibility(8);
                    textView.setText(null);
                }
                textView.setContentDescription(contentDesc);
            }
            if (iconView != null) {
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)iconView.getLayoutParams();
                int bottomMargin = 0;
                if (hasText && iconView.getVisibility() == 0) {
                    bottomMargin = XTabLayout.this.dpToPx(8);
                }
                if (bottomMargin != lp.bottomMargin) {
                    lp.bottomMargin = bottomMargin;
                    iconView.requestLayout();
                }
            }
            if (!hasText && !TextUtils.isEmpty((CharSequence)contentDesc)) {
                this.setOnLongClickListener(this);
            } else {
                this.setOnLongClickListener(null);
                this.setLongClickable(false);
            }
        }

        public boolean onLongClick(View v) {
            int[] screenPos = new int[2];
            this.getLocationOnScreen(screenPos);
            Context context = this.getContext();
            int width = this.getWidth();
            int height = this.getHeight();
            int screenWidth = context.getResources().getDisplayMetrics().widthPixels;
            Toast cheatSheet = Toast.makeText((Context)context, (CharSequence)this.mTab.getContentDescription(), (int)0);
            cheatSheet.setGravity(49, screenPos[0] + width / 2 - screenWidth / 2, height);
            cheatSheet.show();
            return true;
        }

        public Tab getTab() {
            return this.mTab;
        }

        private float approximateLineWidth(Layout layout2, int line, float textSize) {
            return layout2.getLineWidth(line) * (textSize / layout2.getPaint().getTextSize());
        }
    }

    public static final class Tab {
        public static final int INVALID_POSITION = -1;
        private Object mTag;
        private Drawable mIcon;
        private CharSequence mText;
        private CharSequence mContentDesc;
        private int mPosition = -1;
        private View mCustomView;
        private XTabLayout mParent;
        private TabView mView;

        private Tab() {
        }

        @Nullable
        public Object getTag() {
            return this.mTag;
        }

        public int getTextWidth() {
            return this.mView.getTextWidth();
        }

        @NonNull
        public Tab setTag(@Nullable Object tag) {
            this.mTag = tag;
            return this;
        }

        @Nullable
        public View getCustomView() {
            return this.mCustomView;
        }

        @NonNull
        public Tab setCustomView(@Nullable View view) {
            this.mCustomView = view;
            this.updateView();
            return this;
        }

        @NonNull
        public Tab setCustomView(@LayoutRes int resId) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.mView.getContext());
            return this.setCustomView(inflater.inflate(resId, (ViewGroup)this.mView, false));
        }

        @Nullable
        public Drawable getIcon() {
            return this.mIcon;
        }

        public int getPosition() {
            return this.mPosition;
        }

        void setPosition(int position) {
            this.mPosition = position;
        }

        @Nullable
        public CharSequence getText() {
            return this.mText;
        }

        @NonNull
        public Tab setIcon(@Nullable Drawable icon) {
            this.mIcon = icon;
            this.updateView();
            return this;
        }

        @NonNull
        public Tab setIcon(@DrawableRes int resId) {
            if (this.mParent == null) {
                throw new IllegalArgumentException("Tab not attached to a TabLayout");
            }
            return this.setIcon(ContextCompat.getDrawable((Context)this.mParent.getContext(), (int)resId));
        }

        @NonNull
        public Tab setText(@Nullable CharSequence text) {
            this.mText = text;
            this.updateView();
            return this;
        }

        @NonNull
        public Tab setText(@StringRes int resId) {
            if (this.mParent == null) {
                throw new IllegalArgumentException("Tab not attached to a TabLayout");
            }
            return this.setText(this.mParent.getResources().getText(resId));
        }

        public void select() {
            if (this.mParent == null) {
                throw new IllegalArgumentException("Tab not attached to a TabLayout");
            }
            this.mParent.selectTab(this);
        }

        public boolean isSelected() {
            if (this.mParent == null) {
                throw new IllegalArgumentException("Tab not attached to a TabLayout");
            }
            return this.mParent.getSelectedTabPosition() == this.mPosition;
        }

        @NonNull
        public Tab setContentDescription(@StringRes int resId) {
            if (this.mParent == null) {
                throw new IllegalArgumentException("Tab not attached to a TabLayout");
            }
            return this.setContentDescription(this.mParent.getResources().getText(resId));
        }

        @NonNull
        public Tab setContentDescription(@Nullable CharSequence contentDesc) {
            this.mContentDesc = contentDesc;
            this.updateView();
            return this;
        }

        @Nullable
        public CharSequence getContentDescription() {
            return this.mContentDesc;
        }

        private void updateView() {
            if (this.mView != null) {
                this.mView.update();
            }
        }

        private void reset() {
            this.mParent = null;
            this.mView = null;
            this.mTag = null;
            this.mIcon = null;
            this.mText = null;
            this.mContentDesc = null;
            this.mPosition = -1;
            this.mCustomView = null;
        }
    }

    public static interface OnTabSelectedListener {
        public void onTabSelected(Tab var1);

        public void onTabUnselected(Tab var1);

        public void onTabReselected(Tab var1);
    }

    public static @interface XTabIndicatorType {
        public static final int RECT = 1;
        public static final int ROUND_RECT = 2;
        public static final int HALF_ROUND_RECT = 3;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TabGravity {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }
}

