/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.recyclerview;

import android.animation.ValueAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.fshows.android.parker.R;
import com.fshows.android.parker.recyclerview.ILoadMoreView;

public class LoadingMoreFooter
extends LinearLayout
implements ILoadMoreView {
    private static final int SCALE = 2;
    private static final int MAX_HEIGHT = 132;
    private int mState = 0;
    private LinearLayout mLoadMoreLl;
    private TextView mLoadMoreTv;
    private View mNoLoadMoreLl;

    public LoadingMoreFooter(Context context) {
        super(context);
        this.initView(context);
    }

    public LoadingMoreFooter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    @Override
    public void onMove(float delta) {
        int height;
        Log.e((String)"xss", (String)("onMore: " + delta));
        if (delta > 0.0f) {
            delta *= 3.0f;
        }
        if ((height = (int)(-delta) + this.getVisibleHeight()) > 264) {
            height = 264;
        }
        this.setVisibleHeight(height);
        if (this.mState <= 2) {
            if (height > 132) {
                this.setState(1);
            } else {
                this.setState(0);
            }
        }
    }

    public void initView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.yun_refresh_footer, (ViewGroup)this);
        this.mLoadMoreLl = (LinearLayout)this.findViewById(R.id.load_more_ll);
        this.mLoadMoreTv = (TextView)this.findViewById(R.id.load_more_tv);
        this.mNoLoadMoreLl = this.findViewById(R.id.no_load_more_ll);
        this.mLoadMoreLl.setVisibility(8);
        this.mNoLoadMoreLl.setVisibility(8);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
    }

    @Override
    public void setState(int state) {
        switch (state) {
            case 0: {
                this.setVisibility(0);
                this.mLoadMoreTv.setText((CharSequence)"\u4e0a\u62c9\u52a0\u8f7d\u66f4\u591a");
                this.mLoadMoreLl.setVisibility(0);
                this.mNoLoadMoreLl.setVisibility(8);
                break;
            }
            case 1: {
                this.setVisibility(0);
                this.mLoadMoreTv.setText((CharSequence)"\u677e\u5f00\u7acb\u5373\u52a0\u8f7d");
                this.mLoadMoreLl.setVisibility(0);
                this.mNoLoadMoreLl.setVisibility(8);
                break;
            }
            case 2: {
                this.setVisibility(0);
                this.mLoadMoreTv.setText((CharSequence)"\u52a0\u8f7d\u4e2d...");
                this.mLoadMoreLl.setVisibility(0);
                this.mNoLoadMoreLl.setVisibility(8);
                this.smoothScrollTo(132);
                break;
            }
            case 3: {
                this.mLoadMoreTv.setText((CharSequence)"\u52a0\u8f7d\u5b8c\u6210");
                this.postDelayed(() -> this.reset(), 500L);
                this.mLoadMoreLl.setVisibility(8);
                break;
            }
            case 4: {
                this.setVisibility(0);
                this.mLoadMoreLl.setVisibility(8);
                this.mNoLoadMoreLl.setVisibility(0);
                break;
            }
            default: {
                this.setVisibility(8);
            }
        }
        this.mState = state;
    }

    @Override
    public void reset() {
        this.mState = 0;
        this.smoothScrollTo(0);
    }

    @Override
    public void setVisibleHeight(int height) {
        if (height < 0) {
            height = 0;
        }
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, 0);
        lp.height = height;
        this.mLoadMoreLl.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    @Override
    public int getVisibleHeight() {
        return this.mLoadMoreLl.getHeight();
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public void smoothScrollTo(int destHeight) {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.getVisibleHeight(), destHeight});
        animator.setDuration(300L).start();
        animator.addUpdateListener(animation -> this.setVisibleHeight((Integer)animation.getAnimatedValue()));
        animator.start();
    }

    @Override
    public void hideView() {
        this.mLoadMoreLl.setVisibility(8);
        this.mNoLoadMoreLl.setVisibility(8);
    }

    @Override
    public void setNoMoreView(View view) {
        try {
            LinearLayout rootView = (LinearLayout)this.getChildAt(0);
            rootView.removeViewAt(rootView.getChildCount() - 1);
            this.mNoLoadMoreLl = view;
            rootView.addView(this.mNoLoadMoreLl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

