package com.alipay.api.response;

import com.alipay.api.internal.mapping.ApiField;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: mybank.credit.loantrade.repay.uniondeductresult.query response.
 * 
 * @author auto create
 * @since 1.0, 2022-08-26 16:36:54
 */
public class MybankCreditLoantradeRepayUniondeductresultQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 2163732939986659414L;

	/** 
	 * 支付宝用户id
	 */
	@ApiField("alipay_user_id")
	private String alipayUserId;

	/** 
	 * 网商实际还款销帐金额
单位为元
类型为人民币
扣款执行状态为FINISH时有值
	 */
	@ApiField("deduction_amt")
	private String deductionAmt;

	/** 
	 * 还款结果
1.ALL_SUCCESS：全部扣款成功
网商实际还款销帐金额等于机构扣款金额
2.PORTION_SUCCESS：部分扣款成功
网商实际还款销帐金额小于机构扣款金额
3.DEDUCT_FAILED：扣款失败

扣款执行状态为FINISH时有值
	 */
	@ApiField("deduction_result")
	private String deductionResult;

	/** 
	 * 网商扣款执行状态
EXECUTING-执行中
FINISH-执行结束
	 */
	@ApiField("deduction_status")
	private String deductionStatus;

	/** 
	 * 网商侧返回的批次扣款事件单号
	 */
	@ApiField("ev_seq_no")
	private String evSeqNo;

	/** 
	 * 扩展信息，json格式
	 */
	@ApiField("ext")
	private String ext;

	/** 
	 * 机构测扣款金额	
单位为元
类型为人民币
扣款执行状态为FINISH时有值
	 */
	@ApiField("inst_deduction_amt")
	private String instDeductionAmt;

	/** 
	 * 机构查询请求幂等ID，透传回机构
	 */
	@ApiField("request_id")
	private String requestId;

	public void setAlipayUserId(String alipayUserId) {
		this.alipayUserId = alipayUserId;
	}
	public String getAlipayUserId( ) {
		return this.alipayUserId;
	}

	public void setDeductionAmt(String deductionAmt) {
		this.deductionAmt = deductionAmt;
	}
	public String getDeductionAmt( ) {
		return this.deductionAmt;
	}

	public void setDeductionResult(String deductionResult) {
		this.deductionResult = deductionResult;
	}
	public String getDeductionResult( ) {
		return this.deductionResult;
	}

	public void setDeductionStatus(String deductionStatus) {
		this.deductionStatus = deductionStatus;
	}
	public String getDeductionStatus( ) {
		return this.deductionStatus;
	}

	public void setEvSeqNo(String evSeqNo) {
		this.evSeqNo = evSeqNo;
	}
	public String getEvSeqNo( ) {
		return this.evSeqNo;
	}

	public void setExt(String ext) {
		this.ext = ext;
	}
	public String getExt( ) {
		return this.ext;
	}

	public void setInstDeductionAmt(String instDeductionAmt) {
		this.instDeductionAmt = instDeductionAmt;
	}
	public String getInstDeductionAmt( ) {
		return this.instDeductionAmt;
	}

	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}
	public String getRequestId( ) {
		return this.requestId;
	}

}
