package com.alipay.api.response;

import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.domain.AccountDTO;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: anttech.blockchain.defin.saas.payment.pay response.
 * 
 * @author auto create
 * @since 1.0, 2023-03-14 21:06:40
 */
public class AnttechBlockchainDefinSaasPaymentPayResponse extends AlipayResponse {

	private static final long serialVersionUID = 1736367981872427227L;

	/** 
	 * 交易单状态。PAYING(支付处理中);PAY_SUCCESS(支付成功);PAY_FAIL(支付失败); CAPTURING(请款中);CAPTURE_SUCCESS(请款成功);CAPTURE_FAIL(请款失败); REFUNDING(退款中);REFUND_SUCCESS(退款成功);REFUND_FAIL(退款失败); CLOSING(关单中);CLOSE_SUCCESS(关单成功);CLOSE_FAIL(关单失败);
	 */
	@ApiField("order_state")
	private String orderState;

	/** 
	 * 外部业务平台原始交易号
	 */
	@ApiField("out_order_id")
	private String outOrderId;

	/** 
	 * 外部请求ID
	 */
	@ApiField("out_request_id")
	private String outRequestId;

	/** 
	 * 收款方账号
	 */
	@ApiField("payee_account")
	private AccountDTO payeeAccount;

	/** 
	 * 支付提交状态
	 */
	@ApiField("state")
	private String state;

	public void setOrderState(String orderState) {
		this.orderState = orderState;
	}
	public String getOrderState( ) {
		return this.orderState;
	}

	public void setOutOrderId(String outOrderId) {
		this.outOrderId = outOrderId;
	}
	public String getOutOrderId( ) {
		return this.outOrderId;
	}

	public void setOutRequestId(String outRequestId) {
		this.outRequestId = outRequestId;
	}
	public String getOutRequestId( ) {
		return this.outRequestId;
	}

	public void setPayeeAccount(AccountDTO payeeAccount) {
		this.payeeAccount = payeeAccount;
	}
	public AccountDTO getPayeeAccount( ) {
		return this.payeeAccount;
	}

	public void setState(String state) {
		this.state = state;
	}
	public String getState( ) {
		return this.state;
	}

}
