package com.alipay.api.response;

import com.alipay.api.internal.mapping.ApiField;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.trade.advance.settle.query response.
 * 
 * @author auto create
 * @since 1.0, 2022-03-21 10:55:05
 */
public class AlipayTradeAdvanceSettleQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 8697391317595837465L;

	/** 
	 * 受理失败笔数
	 */
	@ApiField("accept_failure_count")
	private Long acceptFailureCount;

	/** 
	 * 放款金额
	 */
	@ApiField("advance_amount")
	private String advanceAmount;

	/** 
	 * 放款笔数
	 */
	@ApiField("advance_count")
	private String advanceCount;

	/** 
	 * 批次放款结果码，SUCCESS：放款成功，PROCESS 放款处理中，FAILURE：放款失败
	 */
	@ApiField("result_code")
	private String resultCode;

	/** 
	 * 放款结果下载链接，放款成功或者失败有下载链接，放款中没有
	 */
	@ApiField("result_url")
	private String resultUrl;

	/** 
	 * 放款子错误码
	 */
	@ApiField("sub_result_code")
	private String subResultCode;

	/** 
	 * 放款子错误描述
	 */
	@ApiField("sub_result_desc")
	private String subResultDesc;

	public void setAcceptFailureCount(Long acceptFailureCount) {
		this.acceptFailureCount = acceptFailureCount;
	}
	public Long getAcceptFailureCount( ) {
		return this.acceptFailureCount;
	}

	public void setAdvanceAmount(String advanceAmount) {
		this.advanceAmount = advanceAmount;
	}
	public String getAdvanceAmount( ) {
		return this.advanceAmount;
	}

	public void setAdvanceCount(String advanceCount) {
		this.advanceCount = advanceCount;
	}
	public String getAdvanceCount( ) {
		return this.advanceCount;
	}

	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}
	public String getResultCode( ) {
		return this.resultCode;
	}

	public void setResultUrl(String resultUrl) {
		this.resultUrl = resultUrl;
	}
	public String getResultUrl( ) {
		return this.resultUrl;
	}

	public void setSubResultCode(String subResultCode) {
		this.subResultCode = subResultCode;
	}
	public String getSubResultCode( ) {
		return this.subResultCode;
	}

	public void setSubResultDesc(String subResultDesc) {
		this.subResultDesc = subResultDesc;
	}
	public String getSubResultDesc( ) {
		return this.subResultDesc;
	}

}
