package com.alipay.api.response;

import java.util.List;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.domain.WidgetGoodsAuditPassResult;
import com.alipay.api.domain.WidgetGoodsAuditResult;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.open.mini.widgetgoods.uploadresult.query response.
 * 
 * @author auto create
 * @since 1.0, 2022-11-04 18:12:57
 */
public class AlipayOpenMiniWidgetgoodsUploadresultQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 2671572497596271524L;

	/** 
	 * 审核通过的商品信息列表，审核出现通过时才返回
	 */
	@ApiListField("audit_pass_goods_info_list")
	@ApiField("widget_goods_audit_pass_result")
	private List<WidgetGoodsAuditPassResult> auditPassGoodsInfoList;

	/** 
	 * 审核驳回的商品信息列表，审核出现驳回时才返回
	 */
	@ApiListField("audit_reject_goods_info_list")
	@ApiField("widget_goods_audit_result")
	private List<WidgetGoodsAuditResult> auditRejectGoodsInfoList;

	/** 
	 * 商品提交生成的唯一标识
	 */
	@ApiField("commit_id")
	private String commitId;

	/** 
	 * alipay.open.mini.widget.goods.upload时提交的小程序ID
	 */
	@ApiField("mini_app_id")
	private String miniAppId;

	public void setAuditPassGoodsInfoList(List<WidgetGoodsAuditPassResult> auditPassGoodsInfoList) {
		this.auditPassGoodsInfoList = auditPassGoodsInfoList;
	}
	public List<WidgetGoodsAuditPassResult> getAuditPassGoodsInfoList( ) {
		return this.auditPassGoodsInfoList;
	}

	public void setAuditRejectGoodsInfoList(List<WidgetGoodsAuditResult> auditRejectGoodsInfoList) {
		this.auditRejectGoodsInfoList = auditRejectGoodsInfoList;
	}
	public List<WidgetGoodsAuditResult> getAuditRejectGoodsInfoList( ) {
		return this.auditRejectGoodsInfoList;
	}

	public void setCommitId(String commitId) {
		this.commitId = commitId;
	}
	public String getCommitId( ) {
		return this.commitId;
	}

	public void setMiniAppId(String miniAppId) {
		this.miniAppId = miniAppId;
	}
	public String getMiniAppId( ) {
		return this.miniAppId;
	}

}
