package com.alipay.api.response;

import java.util.List;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.domain.MiniPrivacyPolicyFieldInfo;
import com.alipay.api.domain.MiniUserDefinePrivacyPolicyFieldInfo;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.open.mini.privacy.query response.
 * 
 * @author auto create
 * @since 1.0, 2023-03-27 10:02:10
 */
public class AlipayOpenMiniPrivacyQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 5231952487926283846L;

	/** 
	 * 联系人邮箱。邮箱和联系电话不可都为空
	 */
	@ApiField("email")
	private String email;

	/** 
	 * 系统定义的隐私字段
	 */
	@ApiListField("mini_privacy_policy_field_infos")
	@ApiField("mini_privacy_policy_field_info")
	private List<MiniPrivacyPolicyFieldInfo> miniPrivacyPolicyFieldInfos;

	/** 
	 * 用户自定义隐私字段。最多支持20个
	 */
	@ApiListField("mini_user_define_privacy_policy_field_infos")
	@ApiField("mini_user_define_privacy_policy_field_info")
	private List<MiniUserDefinePrivacyPolicyFieldInfo> miniUserDefinePrivacyPolicyFieldInfos;

	/** 
	 * 联系人邮箱。邮箱和联系电话不可都为空
	 */
	@ApiField("phone")
	private String phone;

	/** 
	 * 隐私协议对用户公开类型,可选公开(PUBLIC)和不公开(HIDE)
	 */
	@ApiField("public_type")
	private String publicType;

	/** 
	 * 咨询回复时间，单位（天）
	 */
	@ApiField("reply_cycle")
	private String replyCycle;

	/** 
	 * 数据存储地,境内：inside，境外：outside
	 */
	@ApiField("storage_location")
	private String storageLocation;

	public void setEmail(String email) {
		this.email = email;
	}
	public String getEmail( ) {
		return this.email;
	}

	public void setMiniPrivacyPolicyFieldInfos(List<MiniPrivacyPolicyFieldInfo> miniPrivacyPolicyFieldInfos) {
		this.miniPrivacyPolicyFieldInfos = miniPrivacyPolicyFieldInfos;
	}
	public List<MiniPrivacyPolicyFieldInfo> getMiniPrivacyPolicyFieldInfos( ) {
		return this.miniPrivacyPolicyFieldInfos;
	}

	public void setMiniUserDefinePrivacyPolicyFieldInfos(List<MiniUserDefinePrivacyPolicyFieldInfo> miniUserDefinePrivacyPolicyFieldInfos) {
		this.miniUserDefinePrivacyPolicyFieldInfos = miniUserDefinePrivacyPolicyFieldInfos;
	}
	public List<MiniUserDefinePrivacyPolicyFieldInfo> getMiniUserDefinePrivacyPolicyFieldInfos( ) {
		return this.miniUserDefinePrivacyPolicyFieldInfos;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}
	public String getPhone( ) {
		return this.phone;
	}

	public void setPublicType(String publicType) {
		this.publicType = publicType;
	}
	public String getPublicType( ) {
		return this.publicType;
	}

	public void setReplyCycle(String replyCycle) {
		this.replyCycle = replyCycle;
	}
	public String getReplyCycle( ) {
		return this.replyCycle;
	}

	public void setStorageLocation(String storageLocation) {
		this.storageLocation = storageLocation;
	}
	public String getStorageLocation( ) {
		return this.storageLocation;
	}

}
