package com.alipay.api.response;

import java.util.List;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.domain.ContactInformationVO;
import com.alipay.api.domain.PrivacyPolicyVersionVO;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.open.mini.inner.privacy.query response.
 * 
 * @author auto create
 * @since 1.0, 2023-01-11 01:51:41
 */
public class AlipayOpenMiniInnerPrivacyQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 4117713723615566667L;

	/** 
	 * 提供给yuyan的接口，接口有鉴权功能 风险可控
	 */
	@ApiField("app_name")
	private String appName;

	/** 
	 * 隐私协议审核备注
	 */
	@ApiField("audit_memo")
	private String auditMemo;

	/** 
	 * 审核状态
	 */
	@ApiField("audit_status")
	private String auditStatus;

	/** 
	 * 是否同意协议
	 */
	@ApiField("consent_policy")
	private Boolean consentPolicy;

	/** 
	 * 联系方式
	 */
	@ApiListField("contact_information_list")
	@ApiField("contact_information_v_o")
	private List<ContactInformationVO> contactInformationList;

	/** 
	 * 草稿版本
	 */
	@ApiField("draft_version")
	private PrivacyPolicyVersionVO draftVersion;

	/** 
	 * 协议初始化时间
	 */
	@ApiField("init_time")
	private String initTime;

	/** 
	 * 业务小程序id
	 */
	@ApiField("mini_app_id")
	private String miniAppId;

	/** 
	 * 是否需要强制更新
	 */
	@ApiField("need_update")
	private Boolean needUpdate;

	/** 
	 * 线上版本
	 */
	@ApiField("online_version")
	private PrivacyPolicyVersionVO onlineVersion;

	/** 
	 * 是否展示
	 */
	@ApiField("public_type")
	private String publicType;

	/** 
	 * 回复期限
	 */
	@ApiField("reply_cycle")
	private String replyCycle;

	/** 
	 * 协议状态
	 */
	@ApiField("status")
	private String status;

	/** 
	 * 存储地址
	 */
	@ApiField("storage_location")
	private String storageLocation;

	/** 
	 * 小程序类型
	 */
	@ApiField("sub_application_type")
	private String subApplicationType;

	/** 
	 * 协议变更时间
	 */
	@ApiField("update_time")
	private String updateTime;

	public void setAppName(String appName) {
		this.appName = appName;
	}
	public String getAppName( ) {
		return this.appName;
	}

	public void setAuditMemo(String auditMemo) {
		this.auditMemo = auditMemo;
	}
	public String getAuditMemo( ) {
		return this.auditMemo;
	}

	public void setAuditStatus(String auditStatus) {
		this.auditStatus = auditStatus;
	}
	public String getAuditStatus( ) {
		return this.auditStatus;
	}

	public void setConsentPolicy(Boolean consentPolicy) {
		this.consentPolicy = consentPolicy;
	}
	public Boolean getConsentPolicy( ) {
		return this.consentPolicy;
	}

	public void setContactInformationList(List<ContactInformationVO> contactInformationList) {
		this.contactInformationList = contactInformationList;
	}
	public List<ContactInformationVO> getContactInformationList( ) {
		return this.contactInformationList;
	}

	public void setDraftVersion(PrivacyPolicyVersionVO draftVersion) {
		this.draftVersion = draftVersion;
	}
	public PrivacyPolicyVersionVO getDraftVersion( ) {
		return this.draftVersion;
	}

	public void setInitTime(String initTime) {
		this.initTime = initTime;
	}
	public String getInitTime( ) {
		return this.initTime;
	}

	public void setMiniAppId(String miniAppId) {
		this.miniAppId = miniAppId;
	}
	public String getMiniAppId( ) {
		return this.miniAppId;
	}

	public void setNeedUpdate(Boolean needUpdate) {
		this.needUpdate = needUpdate;
	}
	public Boolean getNeedUpdate( ) {
		return this.needUpdate;
	}

	public void setOnlineVersion(PrivacyPolicyVersionVO onlineVersion) {
		this.onlineVersion = onlineVersion;
	}
	public PrivacyPolicyVersionVO getOnlineVersion( ) {
		return this.onlineVersion;
	}

	public void setPublicType(String publicType) {
		this.publicType = publicType;
	}
	public String getPublicType( ) {
		return this.publicType;
	}

	public void setReplyCycle(String replyCycle) {
		this.replyCycle = replyCycle;
	}
	public String getReplyCycle( ) {
		return this.replyCycle;
	}

	public void setStatus(String status) {
		this.status = status;
	}
	public String getStatus( ) {
		return this.status;
	}

	public void setStorageLocation(String storageLocation) {
		this.storageLocation = storageLocation;
	}
	public String getStorageLocation( ) {
		return this.storageLocation;
	}

	public void setSubApplicationType(String subApplicationType) {
		this.subApplicationType = subApplicationType;
	}
	public String getSubApplicationType( ) {
		return this.subApplicationType;
	}

	public void setUpdateTime(String updateTime) {
		this.updateTime = updateTime;
	}
	public String getUpdateTime( ) {
		return this.updateTime;
	}

}
