package com.alipay.api.response;

import java.util.List;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.domain.BundleInstanceVO;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.open.mini.bundle.query response.
 * 
 * @author auto create
 * @since 1.0, 2020-03-02 15:54:28
 */
public class AlipayOpenMiniBundleQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 7398246989527981634L;

	/** 
	 * 端标识，用于表明端的唯一标识
	 */
	@ApiField("bundle_id")
	private String bundleId;

	/** 
	 * 端实例信息
	 */
	@ApiListField("bundle_instance_vos")
	@ApiField("bundle_instance_v_o")
	private List<BundleInstanceVO> bundleInstanceVos;

	/** 
	 * 英文名
	 */
	@ApiField("english_name")
	private String englishName;

	/** 
	 * 主键
	 */
	@ApiField("id")
	private String id;

	/** 
	 * 图片地址
	 */
	@ApiField("logo")
	private String logo;

	/** 
	 * 端名称
	 */
	@ApiField("name")
	private String name;

	/** 
	 * 支付宝码规则为 alipays://platformapi/startapp?appId=%s，输入框只需要填入alipays，业务方自定义前缀即可
	 */
	@ApiField("qrcode_prex")
	private String qrcodePrex;

	public void setBundleId(String bundleId) {
		this.bundleId = bundleId;
	}
	public String getBundleId( ) {
		return this.bundleId;
	}

	public void setBundleInstanceVos(List<BundleInstanceVO> bundleInstanceVos) {
		this.bundleInstanceVos = bundleInstanceVos;
	}
	public List<BundleInstanceVO> getBundleInstanceVos( ) {
		return this.bundleInstanceVos;
	}

	public void setEnglishName(String englishName) {
		this.englishName = englishName;
	}
	public String getEnglishName( ) {
		return this.englishName;
	}

	public void setId(String id) {
		this.id = id;
	}
	public String getId( ) {
		return this.id;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}
	public String getLogo( ) {
		return this.logo;
	}

	public void setName(String name) {
		this.name = name;
	}
	public String getName( ) {
		return this.name;
	}

	public void setQrcodePrex(String qrcodePrex) {
		this.qrcodePrex = qrcodePrex;
	}
	public String getQrcodePrex( ) {
		return this.qrcodePrex;
	}

}
