package com.alipay.api.response;

import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.domain.DeliveryBaseInfo;
import com.alipay.api.domain.DeliveryPublicUnionPlayConfig;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.marketing.activity.publicuniondelivery.query response.
 * 
 * @author auto create
 * @since 1.0, 2022-03-11 11:30:30
 */
public class AlipayMarketingActivityPublicuniondeliveryQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 8565613819122831438L;

	/** 
	 * 投放计划基础信息。
	 */
	@ApiField("delivery_base_info")
	private DeliveryBaseInfo deliveryBaseInfo;

	/** 
	 * 投放计划错误信息描述，如投放计划审核失败时为审核失败原因。
	 */
	@ApiField("delivery_error_msg")
	private String deliveryErrorMsg;

	/** 
	 * 投放计划id
	 */
	@ApiField("delivery_id")
	private String deliveryId;

	/** 
	 * 投放计划玩法配置。 限制：投放玩法配置有且仅能配置一个。
	 */
	@ApiField("delivery_play_config")
	private DeliveryPublicUnionPlayConfig deliveryPlayConfig;

	/** 
	 * 投放计划状态。 枚举值： ACTIVE：生效中 INACTIVE：失效状态 AUDITING：审核中 AUDIT_NO_PASS：审核不通过。
	 */
	@ApiField("delivery_status")
	private String deliveryStatus;

	public void setDeliveryBaseInfo(DeliveryBaseInfo deliveryBaseInfo) {
		this.deliveryBaseInfo = deliveryBaseInfo;
	}
	public DeliveryBaseInfo getDeliveryBaseInfo( ) {
		return this.deliveryBaseInfo;
	}

	public void setDeliveryErrorMsg(String deliveryErrorMsg) {
		this.deliveryErrorMsg = deliveryErrorMsg;
	}
	public String getDeliveryErrorMsg( ) {
		return this.deliveryErrorMsg;
	}

	public void setDeliveryId(String deliveryId) {
		this.deliveryId = deliveryId;
	}
	public String getDeliveryId( ) {
		return this.deliveryId;
	}

	public void setDeliveryPlayConfig(DeliveryPublicUnionPlayConfig deliveryPlayConfig) {
		this.deliveryPlayConfig = deliveryPlayConfig;
	}
	public DeliveryPublicUnionPlayConfig getDeliveryPlayConfig( ) {
		return this.deliveryPlayConfig;
	}

	public void setDeliveryStatus(String deliveryStatus) {
		this.deliveryStatus = deliveryStatus;
	}
	public String getDeliveryStatus( ) {
		return this.deliveryStatus;
	}

}
