package com.alipay.api.response;

import java.util.List;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.domain.ActivityBaseInfo;
import com.alipay.api.domain.ActivityOrderBaseInfo;
import com.alipay.api.domain.VoucherDeductInfo;
import com.alipay.api.domain.VoucherDisplayInfo;
import com.alipay.api.domain.VoucherInstanceDetailInfo;
import com.alipay.api.domain.VoucherSaleModeInfo;
import com.alipay.api.domain.VoucherUseGuideInfo;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.marketing.activity.order.query response.
 * 
 * @author auto create
 * @since 1.0, 2022-09-14 17:11:10
 */
public class AlipayMarketingActivityOrderQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 3711199771127653617L;

	/** 
	 * 活动基础信息
	 */
	@ApiField("activity_base_info")
	private ActivityBaseInfo activityBaseInfo;

	/** 
	 * 订单基础信息
	 */
	@ApiField("order_base_info")
	private ActivityOrderBaseInfo orderBaseInfo;

	/** 
	 * 券优惠抵扣信息
	 */
	@ApiField("voucher_deduct_info")
	private VoucherDeductInfo voucherDeductInfo;

	/** 
	 * 券展示信息
	 */
	@ApiField("voucher_display_pattern_info")
	private VoucherDisplayInfo voucherDisplayPatternInfo;

	/** 
	 * 券实例详细信息
	 */
	@ApiListField("voucher_instance_detail_info")
	@ApiField("voucher_instance_detail_info")
	private List<VoucherInstanceDetailInfo> voucherInstanceDetailInfo;

	/** 
	 * 券售卖信息
	 */
	@ApiField("voucher_sale_mode_info")
	private VoucherSaleModeInfo voucherSaleModeInfo;

	/** 
	 * 券核销详情
	 */
	@ApiField("voucher_use_guide_info")
	private VoucherUseGuideInfo voucherUseGuideInfo;

	public void setActivityBaseInfo(ActivityBaseInfo activityBaseInfo) {
		this.activityBaseInfo = activityBaseInfo;
	}
	public ActivityBaseInfo getActivityBaseInfo( ) {
		return this.activityBaseInfo;
	}

	public void setOrderBaseInfo(ActivityOrderBaseInfo orderBaseInfo) {
		this.orderBaseInfo = orderBaseInfo;
	}
	public ActivityOrderBaseInfo getOrderBaseInfo( ) {
		return this.orderBaseInfo;
	}

	public void setVoucherDeductInfo(VoucherDeductInfo voucherDeductInfo) {
		this.voucherDeductInfo = voucherDeductInfo;
	}
	public VoucherDeductInfo getVoucherDeductInfo( ) {
		return this.voucherDeductInfo;
	}

	public void setVoucherDisplayPatternInfo(VoucherDisplayInfo voucherDisplayPatternInfo) {
		this.voucherDisplayPatternInfo = voucherDisplayPatternInfo;
	}
	public VoucherDisplayInfo getVoucherDisplayPatternInfo( ) {
		return this.voucherDisplayPatternInfo;
	}

	public void setVoucherInstanceDetailInfo(List<VoucherInstanceDetailInfo> voucherInstanceDetailInfo) {
		this.voucherInstanceDetailInfo = voucherInstanceDetailInfo;
	}
	public List<VoucherInstanceDetailInfo> getVoucherInstanceDetailInfo( ) {
		return this.voucherInstanceDetailInfo;
	}

	public void setVoucherSaleModeInfo(VoucherSaleModeInfo voucherSaleModeInfo) {
		this.voucherSaleModeInfo = voucherSaleModeInfo;
	}
	public VoucherSaleModeInfo getVoucherSaleModeInfo( ) {
		return this.voucherSaleModeInfo;
	}

	public void setVoucherUseGuideInfo(VoucherUseGuideInfo voucherUseGuideInfo) {
		this.voucherUseGuideInfo = voucherUseGuideInfo;
	}
	public VoucherUseGuideInfo getVoucherUseGuideInfo( ) {
		return this.voucherUseGuideInfo;
	}

}
