package com.alipay.api.response;

import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.domain.ServiceRecord;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.iservice.ccm.servicerecord.query response.
 * 
 * @author auto create
 * @since 1.0, 2021-05-21 14:35:54
 */
public class AlipayIserviceCcmServicerecordQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 8553453138378247713L;

	/** 
	 * 查询结果的页码，起始值为 1，默认值为 1
	 */
	@ApiField("page_num")
	private Long pageNum;

	/** 
	 * 分页查询时设置的每页记录数，最大值 100 行，默认为 10
	 */
	@ApiField("page_size")
	private Long pageSize;

	/** 
	 * 服务记录
	 */
	@ApiField("records")
	private ServiceRecord records;

	/** 
	 * API调用结果码，成功为OK
	 */
	@ApiField("result_code")
	private String resultCode;

	/** 
	 * API调用结果描述，比如调用失败的时候会显示具体的错误信息
	 */
	@ApiField("result_msg")
	private String resultMsg;

	/** 
	 * 总条目数
	 */
	@ApiField("total_count")
	private Long totalCount;

	public void setPageNum(Long pageNum) {
		this.pageNum = pageNum;
	}
	public Long getPageNum( ) {
		return this.pageNum;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}
	public Long getPageSize( ) {
		return this.pageSize;
	}

	public void setRecords(ServiceRecord records) {
		this.records = records;
	}
	public ServiceRecord getRecords( ) {
		return this.records;
	}

	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}
	public String getResultCode( ) {
		return this.resultCode;
	}

	public void setResultMsg(String resultMsg) {
		this.resultMsg = resultMsg;
	}
	public String getResultMsg( ) {
		return this.resultMsg;
	}

	public void setTotalCount(Long totalCount) {
		this.totalCount = totalCount;
	}
	public Long getTotalCount( ) {
		return this.totalCount;
	}

}
