package com.alipay.api.response;

import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.domain.AuthInfoDTO;
import com.alipay.api.domain.ExtCardInfo;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.fund.accountbook.uni.query response.
 * 
 * @author auto create
 * @since 1.0, 2023-03-01 16:50:35
 */
public class AlipayFundAccountbookUniQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 2882751457852424828L;

	/** 
	 * 开通的资金记账本id
，失败不返回。
	 */
	@ApiField("account_book_id")
	private String accountBookId;

	/** 
	 * 授权信息
	 */
	@ApiField("auth_info")
	private AuthInfoDTO authInfo;

	/** 
	 * 必选	记账本的可用余额
（非支付宝账户余额）
	 */
	@ApiField("available_amount")
	private String availableAmount;

	/** 
	 * 网银打款的外卡信息
	 */
	@ApiField("ext_card_info")
	private ExtCardInfo extCardInfo;

	public void setAccountBookId(String accountBookId) {
		this.accountBookId = accountBookId;
	}
	public String getAccountBookId( ) {
		return this.accountBookId;
	}

	public void setAuthInfo(AuthInfoDTO authInfo) {
		this.authInfo = authInfo;
	}
	public AuthInfoDTO getAuthInfo( ) {
		return this.authInfo;
	}

	public void setAvailableAmount(String availableAmount) {
		this.availableAmount = availableAmount;
	}
	public String getAvailableAmount( ) {
		return this.availableAmount;
	}

	public void setExtCardInfo(ExtCardInfo extCardInfo) {
		this.extCardInfo = extCardInfo;
	}
	public ExtCardInfo getExtCardInfo( ) {
		return this.extCardInfo;
	}

}
