package com.alipay.api.response;

import com.alipay.api.internal.mapping.ApiField;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.commerce.water.usertask.query response.
 * 
 * @author auto create
 * @since 1.0, 2023-07-05 17:21:51
 */
public class AlipayCommerceWaterUsertaskQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 2644975164467843677L;

	/** 
	 * 用户下信用单生成的芝麻单号
	 */
	@ApiField("out_biz_no")
	private String outBizNo;

	/** 
	 * 商户创建活动时使用的奖品名
	 */
	@ApiField("prize_name")
	private String prizeName;

	/** 
	 * 奖品所对应的价格
	 */
	@ApiField("prize_price")
	private String prizePrice;

	/** 
	 * 商户创建的任务id
	 */
	@ApiField("task_id")
	private String taskId;

	/** 
	 * 商户创建的活动名称
	 */
	@ApiField("task_name")
	private String taskName;

	/** 
	 * 任务所对应的资金状态
INIT：初始化
WAIT_USER_CONFIRM：待用户确认扣款
PAYING：扣款中
PAYED：已扣款
NON_PAY：无需扣款
	 */
	@ApiField("task_pay_status")
	private String taskPayStatus;

	/** 
	 * 用户的任务状态
NON_SIGN_UP：未报名
SIGN_UP：已报名
GOING：参与中
TIMEOUT：任务超期
DONE：任务结束
	 */
	@ApiField("task_status")
	private String taskStatus;

	public void setOutBizNo(String outBizNo) {
		this.outBizNo = outBizNo;
	}
	public String getOutBizNo( ) {
		return this.outBizNo;
	}

	public void setPrizeName(String prizeName) {
		this.prizeName = prizeName;
	}
	public String getPrizeName( ) {
		return this.prizeName;
	}

	public void setPrizePrice(String prizePrice) {
		this.prizePrice = prizePrice;
	}
	public String getPrizePrice( ) {
		return this.prizePrice;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}
	public String getTaskId( ) {
		return this.taskId;
	}

	public void setTaskName(String taskName) {
		this.taskName = taskName;
	}
	public String getTaskName( ) {
		return this.taskName;
	}

	public void setTaskPayStatus(String taskPayStatus) {
		this.taskPayStatus = taskPayStatus;
	}
	public String getTaskPayStatus( ) {
		return this.taskPayStatus;
	}

	public void setTaskStatus(String taskStatus) {
		this.taskStatus = taskStatus;
	}
	public String getTaskStatus( ) {
		return this.taskStatus;
	}

}
