package com.alipay.api.response;

import java.util.List;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.domain.BsEnrolledRecord;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.commerce.operation.bs.enrolled.query response.
 * 
 * @author auto create
 * @since 1.0, 2023-04-18 15:57:59
 */
public class AlipayCommerceOperationBsEnrolledQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 4129478887389499486L;

	/** 
	 * 报名记录列表
	 */
	@ApiListField("enrolled_records")
	@ApiField("bs_enrolled_record")
	private List<BsEnrolledRecord> enrolledRecords;

	/** 
	 * 分页页码，从1开始
	 */
	@ApiField("page_index")
	private Long pageIndex;

	/** 
	 * 分页大小
	 */
	@ApiField("page_size")
	private Long pageSize;

	/** 
	 * 查询已报名的计划总数
	 */
	@ApiField("total_count")
	private Long totalCount;

	public void setEnrolledRecords(List<BsEnrolledRecord> enrolledRecords) {
		this.enrolledRecords = enrolledRecords;
	}
	public List<BsEnrolledRecord> getEnrolledRecords( ) {
		return this.enrolledRecords;
	}

	public void setPageIndex(Long pageIndex) {
		this.pageIndex = pageIndex;
	}
	public Long getPageIndex( ) {
		return this.pageIndex;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}
	public Long getPageSize( ) {
		return this.pageSize;
	}

	public void setTotalCount(Long totalCount) {
		this.totalCount = totalCount;
	}
	public Long getTotalCount( ) {
		return this.totalCount;
	}

}
