package com.alipay.api.response;

import com.alipay.api.internal.mapping.ApiField;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.boss.prod.casign.signer.query response.
 * 
 * @author auto create
 * @since 1.0, 2022-05-31 15:15:13
 */
public class AlipayBossProdCasignSignerQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 3383414673876246677L;

	/** 
	 * 用户的CA证书过期时间
	 */
	@ApiField("cert_expire_date")
	private String certExpireDate;

	/** 
	 * 用户的CA证书颁发机构
	 */
	@ApiField("cert_quth_org")
	private String certQuthOrg;

	/** 
	 * 用户的CA证书序列号
	 */
	@ApiField("cert_sn")
	private String certSn;

	/** 
	 * 法代证件号码，机构用户信息
	 */
	@ApiField("legal_cert_number")
	private String legalCertNumber;

	/** 
	 * 法代证件类型，机构用户信息
	 */
	@ApiField("legal_cert_type")
	private String legalCertType;

	/** 
	 * 法代名称，机构用户信息
	 */
	@ApiField("legal_name")
	private String legalName;

	/** 
	 * 用户ID，由业务系统提供
	 */
	@ApiField("sign_user_id")
	private String signUserId;

	/** 
	 * 用户证件号码
	 */
	@ApiField("user_cert_number")
	private String userCertNumber;

	/** 
	 * 用户证件类型，个人身份证“CRED_PSN_CH_IDCARD”，统一社会信用代码“CRED_ORG_USCC”
	 */
	@ApiField("user_cert_type")
	private String userCertType;

	/** 
	 * 用户归属类型;内部用户"INTERNAL",外部用户"EXTERNAL"。
	 */
	@ApiField("user_domain")
	private String userDomain;

	/** 
	 * 用户名称
	 */
	@ApiField("user_name")
	private String userName;

	/** 
	 * 用户类型，个人“PERSON”，机构“ORG”
	 */
	@ApiField("user_type")
	private String userType;

	public void setCertExpireDate(String certExpireDate) {
		this.certExpireDate = certExpireDate;
	}
	public String getCertExpireDate( ) {
		return this.certExpireDate;
	}

	public void setCertQuthOrg(String certQuthOrg) {
		this.certQuthOrg = certQuthOrg;
	}
	public String getCertQuthOrg( ) {
		return this.certQuthOrg;
	}

	public void setCertSn(String certSn) {
		this.certSn = certSn;
	}
	public String getCertSn( ) {
		return this.certSn;
	}

	public void setLegalCertNumber(String legalCertNumber) {
		this.legalCertNumber = legalCertNumber;
	}
	public String getLegalCertNumber( ) {
		return this.legalCertNumber;
	}

	public void setLegalCertType(String legalCertType) {
		this.legalCertType = legalCertType;
	}
	public String getLegalCertType( ) {
		return this.legalCertType;
	}

	public void setLegalName(String legalName) {
		this.legalName = legalName;
	}
	public String getLegalName( ) {
		return this.legalName;
	}

	public void setSignUserId(String signUserId) {
		this.signUserId = signUserId;
	}
	public String getSignUserId( ) {
		return this.signUserId;
	}

	public void setUserCertNumber(String userCertNumber) {
		this.userCertNumber = userCertNumber;
	}
	public String getUserCertNumber( ) {
		return this.userCertNumber;
	}

	public void setUserCertType(String userCertType) {
		this.userCertType = userCertType;
	}
	public String getUserCertType( ) {
		return this.userCertType;
	}

	public void setUserDomain(String userDomain) {
		this.userDomain = userDomain;
	}
	public String getUserDomain( ) {
		return this.userDomain;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}
	public String getUserName( ) {
		return this.userName;
	}

	public void setUserType(String userType) {
		this.userType = userType;
	}
	public String getUserType( ) {
		return this.userType;
	}

}
